function criaTabelaFluxos(data) {
    function retornaBotaoOpcoes(data) {
        var retorno = '<div> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes fluxosDatatableButtonControl" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button type="button" class="dropdown-item fluxosDatatableButtonControl" title="Alterar" id="btnAlterar">Alterar</button>     ' +
            '    <button type="button" class="dropdown-item fluxosDatatableButtonControl" title="Excluir" id="btnExcluir">Excluir</button>     ' +
            '</div>';
        return retorno;
    }

    if ($.fn.DataTable.isDataTable('#tabelaFluxos')) {
        $('#tabelaFluxos').DataTable().destroy();
        $('#tabelaFluxos').empty();
    }

    const columns = [
        {
            data: 'ID',
            title: 'Id'
        },
        {
            data: 'COD_PARTE',
            title: 'Parte'
        },
        {
            data: 'DESC_PARTE',
            title: 'Desc. Parte'
        },
        {
            data: 'COD_FLUXO',
            title: 'Fluxo'
        },
        {
            data: 'DESC_FLUXO',
            title: 'Desc. Fluxo'
        }
    ];

    $("#tabelaFluxos").DataTable({
        sort: false,
        paging: false,
        destroy: true,
        lengthChange: false,
        filter: false,
        info: false,
        columnDefs: [
            {
                targets: [0],
                visible: false,
            },
            {
                targets: [1],
                render: function (data) {
                    return retornaBotaoOpcoes(data);
                },
            },
        ],
        autoWidth: true,
        data,
        columns
    }).draw(false);

    $('#tabelaFluxos tbody').unbind('click');
    $('#tabelaFluxos tbody').on('click', 'tr', async function (e) {
        if ($('#tabelaFluxos').DataTable().data().length > 0 && !$('#btnIncluirFluxo').hasClass('d-none')) {
            $('#tabelaFluxos').DataTable().$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
            filtraSetoresFluxo($('#tabelaFluxos').DataTable().row($(this)).data());
        }
    });
}

function criaTabelaSetores(data) {
    if ($.fn.DataTable.isDataTable('#tabelaSetores')) {
        $('#tabelaSetores').DataTable().destroy();
        $('#tabelaSetores').empty();
    }

    const columns = [
        {
            data: 'ORDEM',
            title: 'Ordem'
        },
        {
            data: 'SETOR',
            title: 'Setor'
        },
        {
            data: 'DESCRICAO',
            title: 'Desc. Setor'
        },
        {
            data: 'TEMPO_OPER',
            title: 'Tempo Operação'
        },
        {
            data: 'TEMPO_PECA',
            title: 'Tempo Peça'
        },
        {
            data: 'PARTE',
            title: 'Parte'
        },
        {
            data: 'FLUXO',
            title: 'Fluxo'
        }
    ]

    $("#tabelaSetores").DataTable({
        sort: false,
        paging: false,
        destroy: true,
        lengthChange: false,
        filter: true,
        info: false,
        autoWidth: true,
        data,
        columns
    }).draw(false);

    setTimeout(() => {
        if ($('#tabelaFluxos').DataTable().data().length > 0) {
            $($('#tabelaFluxos tr')[1]).trigger('click');
        }
    }, 0)
}

function habilitaEdicaoFluxo() {
    $('.fluxoControl').prop('disabled', false)
    $('#btnIncluirFluxo').addClass('d-none')
    $('#btnConfirmarFluxo').removeClass('d-none')
    $('#btnDesistirFluxo').removeClass('d-none')
    $('.fluxosDatatableButtonControl').prop('disabled', true)
}

function desabilitaEdicaoFluxo() {
    $('.fluxoControl').prop('disabled', true)
    $('#btnIncluirFluxo').removeClass('d-none')
    $('#btnConfirmarFluxo').addClass('d-none')
    $('#btnDesistirFluxo').addClass('d-none')
    $('#txtParteFluxo').val('')
    $('#txtFluxoFluxo').val('')
    $("#tabelaFluxos tr").removeClass("selected")
    $('.fluxosDatatableButtonControl').prop('disabled', false)
}

function insereValoresEdicaoFluxo(data) {
    insereValor('#txtFluxoFluxo', data.COD_FLUXO, data.DESC_FLUXO)
    insereValor('#txtParteFluxo', data.COD_PARTE, data.DESC_PARTE)
}

async function adicionaRegistroFluxo(data) {
    try {

        const fluxo = {
            fluxo: data.COD_FLUXO,
            parte: data.COD_PARTE
        }

        const datatable = $('#tabelaFluxos').DataTable()
        const selectedRow = datatable.rows('.selected')
        const datatableData = datatable.data().toArray()
        const editingRegister = selectedRow.data().toArray()

        if (!editingRegister || editingRegister.length === 0) {
            if (datatableData.find(e => e.COD_PARTE === data.COD_PARTE && e.COD_FLUXO === data.COD_FLUXO)) {
                msgErro('Esse registro já existe, impossível continuar.')
                return
            }

            const currentMaxId = datatableData.reduce((max, obj) => {
                return obj.ID > max ? obj.ID : max
            }, 0)

            data.ID = currentMaxId + 1

            $('#tabelaFluxos').DataTable().row.add(data).draw(false)
        } else {
            const [index] = selectedRow.indexes().toArray()
            const existingRegisterCount = datatableData.filter((e, i) => e.COD_PARTE === data.COD_PARTE && e.COD_FLUXO === data.COD_FLUXO && index !== i)

            if (existingRegisterCount && existingRegisterCount.length > 0) {
                msgErro('Esse registro já existe, impossível continuar.')
                return
            }

            if (editingRegister.length > 1) {
                throw new Error()
            }

            const [dataSelected] = editingRegister
            data.ID = dataSelected.ID

            $('#tabelaFluxos').DataTable().row(index).data(data).draw(false)
            removeSetoresFluxoAntigo()
        }
        await adicionaSetores(fluxo)
    } catch (e) {
        console.log(e)
        msgErro('Ocorreu um problema ao editar o registro, por favor tente novamente.')
    } finally {
        desabilitaEdicaoFluxo()
    }
}

function removeSetoresFluxoAntigo() {
    $('#tabelaSetores').DataTable().rows({ search: 'applied' }).remove().draw(false)
}

async function adicionaSetores(fluxo) {
    const response = await requisicao("GET", `/sisplan/cadcaracteristica/V1/buscasetoresfluxo?`, `&FLUXO=${encodeURIComponent(JSON.stringify(fluxo))}`, '', 30000)

    if (!response) {
        return
    }

    const json = await response.json()
    if (response.status != 200) {
        msgErro(json.mensagem)
        return
    }

    const data = $('#tabelaSetores').DataTable().data().toArray()

    criaTabelaSetores([...data, ...json])
}

function filtraSetoresFluxo({ COD_PARTE: parte, COD_FLUXO: fluxo }) {
    $('#tabelaSetores').DataTable().column(5).search(`^${parte.trim()}$|^$`, true, false).column(6).search(`^${fluxo.trim()}$|^$`, true, false).draw(false);
}

function excluiFluxo(row) {
    row.remove().draw(false)
    $('#tabelaSetores').DataTable().rows({ search: 'applied' }).remove().draw(false)
}