$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovaMarkup',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de uma Markup.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaMarkup',
                popover: {
                    title: 'Tabela Markups',
                    description: 'Aqui estão os dados das Markups cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("CADMARKUP");

    // autocompleta 
    $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"CAD_MARKUP", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    // pesquisa
    $('#btnCodigo').pesquisa('#txtCodigo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAD_MARKUP", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Markup', 'CAD_MARKUP');

    $('#btnLimpaCodigo').on('click', function () {
        $('#txtCodigo').val('');
    });

    $("#btnFiltros").on("click", function () {
        $("#modal-filtros").modal("show");
    })

    $('#btnNovoMarkup').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "cadmarkup/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '    <button class="dropdown-item" type="button" title="Duplicar" id="btn-duplicar">Duplicar</button>  ' +
            '</div>';
        return retorno;
    };

    consultaMarkup();

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaMarkup(true);
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtClasseGerConsulta').val('');
        $('#txtHistoricoConsulta').val('');
        $('#txtSituacaoConsulta').val('');
        $('#txtCondPagamentoConsulta').val('');
    });

    $('#tabelaMarkup').on('click', '#btn-duplicar', async function () {
        let data = $('#tabelaMarkup').DataTable().row($(this).parents('tr')).data();
        $('#modalDuplicarMarkup').modal('show');
        $('#txtCodigoOrigem').val(`[${data.CODIGO}] - ${data.DESCRICAO}`)
    });

    async function usaIndice(data) {
        let valida = await buscaValor('PRECO', 'CLIENTE', 'CLIENTE', data)
        if (!!valida) {
            throw msgAlerta('Markup já está sendo utilizado.');
        }
    }

    $('#tabelaMarkup').on('click', '#btn-excluir', async function () {
        let data = $('#tabelaMarkup').DataTable().row($(this).parents('tr')).data();
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                await excluirMarkup(data.CODIGO);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluirMarkup(data) {
        await usaIndice(data)
        try {
            $.LoadingOverlay("show");
            try {
                const response = await requisicao('DELETE', `/sisplan/markup/v1/markup?`, `CODIGO=${data}&EMP_ID=${getCookie('emp_id')}`, 15000);
                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/cadmarkup`
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#btnDuplicarMarkup').on('click', async function () {
        if (!$('#txtCodigoDestino').val()) {
            throw msgAlerta('Código não informado, impossível continuar!');
        }
        if (!$('#txtDescricaoDestino').val()) {
            throw msgAlerta('Descrição não informada, impossível continuar!');
        }
        const response = await requisicao('POST', `/sisplan/markup/v1/duplicamarkup?`, `CODIGO_ORIGEM=${pegaChave('#txtCodigoOrigem')}&CODIGO_DESTINO=${$('#txtCodigoDestino').val()}&DESCRICAO_DESTINO=${$('#txtDescricaoDestino').val()}&EMP_ID=${getCookie('emp_id')}`, 15000);

        if (!response) {
            return
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
        }

        toastr.success(`Markup duplicado com sucesso: ${jsonStr.codigo}!`, "Confirmação", {
            toastClass: "success",
            iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
                window.location.href = `${BASE_URI}/cadmarkup`
            },
        }).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
        });
    });

    async function consultaMarkup(bBotao = false) {

        try {
            $.LoadingOverlay("show");
            let response;
            let codigo = pegaChave('#txtCodigo') != '' ? ` AND CODIGO = '${pegaChave('#txtCodigo')}'` : '';
            if (bBotao) {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"CAD_MARKUP", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["1=1 ${codigo}"]}`, null);
            } else {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"CAD_MARKUP", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null, "limit": 10000}', null);
            }

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tabelaMarkup').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,

                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    "data": "CODIGO"
                },
                {
                    "data": "DESCRICAO"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    }
                }]
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }

    }

    $('#tabelaMarkup').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaMarkup').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('CADMARKUP', data.CODIGO);
            if (registroLiberado) {
                window.location.href = `cadmarkup/${data.CODIGO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaMarkup').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaMarkup').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('CADMARKUP', data.CODIGO);
            if (registroLiberado) {
                window.location.href = `cadmarkup/${data.CODIGO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

});