$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#conteudo',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtCodigo',
      popover: {
        title: 'Código',
        description: 'Adicione neste campo o código da qualidade.',
        position: 'top'
      }
    },
    {
      element: '#txtDescricao',
      popover: {
        title: 'Descrição',
        description: 'Adicionamos aqui uma descrição sobre este cadastro.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar o registro.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let codigoQualidade = parametros[parametros.length - 1];

  if (codigoQualidade != "" && codigoQualidade != "create") {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ 
            "tabela":"TABQUL", "camposSelect":["CODIGO", "DESCRICAO", "ATIVO", "CODIGO2"],
            "where": ["CODIGO =  '${codigoQualidade}'"]}`, null

        );

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.RESULT[0].mensagem);
          return;
        }
        $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
        $("#txtDescricao").val(jsonStr.RESULT[0][0].DESCRICAO);
        $('#txtCodigo2').val(jsonStr.RESULT[0][0].CODIGO2);
        if (jsonStr.RESULT[0][0].ATIVO == 'S') {
          $("#cbAtivo").prop('checked', true);
        } else {
          $("#cbAtivo").prop('checked', false);
        }

      } catch (error) {
        console.error(error);
        msgAlerta(`Não foi possível buscar os dados:`);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }


  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/qualidade`;
  })

  async function gravaStatus() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtCodigo').val() == '') {
        msgAlerta('Preencha o campo Código');
        return;
      }
      if ($('#txtDescricao').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }

      let qualidade = {}

      qualidade.CODIGO = $('#txtCodigo').val().toUpperCase();
      qualidade.DESCRICAO = $('#txtDescricao').val().toUpperCase();
      qualidade.ATIVO = $('#cbAtivo').is(':checked') ? 'S' : 'N';
      qualidade.QUALIDADE = $('#cbAtivo').is(':checked') ? 'S' : 'N';
      qualidade.CODIGO2 = $('#txtCodigo2').val();

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/qualidade?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(qualidade)}`, 15000);
      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }
      toastr.success(
        `Cadastro efetuado com sucesso!
         Qualidade: ${qualidade.CODIGO}`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/qualidade`;
        }
      }).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnGravar').on('click', async function () {
    if (codigoQualidade === 'create') {
      const codigo = $('#txtCodigo').val();
      let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"TABQUL", 
                "camposSelect":["CODIGO", "DESCRICAO"], 
                "where": ["CODIGO = '${codigo}'"]}`, null);

      let json = await response.json();
      if (json.RESULT[0].length > 0) {
        msgAlerta('Código já existe. Favor verifique!');
        return;
      }
    }
    await gravaStatus()
  })
});
