<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Emissão de Cheque</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.258.28.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.258.28.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.258.28.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.258.28.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.258.28.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.258.28.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.258.28.1" />
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.258.28.1">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.258.28.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.258.28.1">
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.258.28.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.258.28.1">

  <style>
    .form-check {
      margin-left: 8px;
      margin-bottom: 10px;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 0.5em 0 0.5rem !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      border-radius: 3px !important;
    }

    .icheck-primary {
      margin-top: 0px !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Emissão de Cheque</h1>
            </div>
            <div class="col-sm-6">

            </div>
          </div>
        </div>
        <div class="container-fluid">
          <div class="row card">
            <div class="col-sm-12 mt-3">
              <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
              <button class="btn btn-danger btn-sisp" id="btnMovimentacao"><span class="fas fa-plus"></span> Movimentação</button>
              <button class="btn btn-secondary btn-sisp" id="btnImprimir" data-toggle="modal"><i class="fas fa-print"></i> Imprimir</button>
            </div>
            <div class="col-sm-12 table-responsive card-body">
              <h5>Lista de cheques</h5>
              <table id="tabelaCheque" class="table table-sm table-select table-hover" style="white-space: nowrap" width="100%">
                <thead>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title">Filtros</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pb-0">
          <div>
            <!-- <div class="card-body pt-0"> -->

            <div class="form-row" id="divRelAnalise">

              <div class="form-group col-lg-3 col-3 col-sm-6 mb-0">
                <div class="">
                  <label for="">Vencimento de/até:</label>
                  <div class="input-group">
                    <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtVencimentoI" name="DataDe">
                    <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtVencimentoF" name="DataAte">
                  </div>
                </div>
              </div>

              <div class="form-group col-lg-3 col-3 col-sm-6 mb-0">
                <div class="">
                  <label for="">Emissão de/até:</label>
                  <div class="input-group">
                    <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtEmissaoI" name="DataDe">
                    <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtDtEmissaoF" name="DataAte">
                  </div>
                </div>
              </div>

              <div class="form-group col-lg-6 col-6 col-sm-12 mt-3 mb-0">
                <fieldset class="form border-Field mb-0 pb-0">
                  <legend class="textoBorda mb-0 pb-0">Stituação</legend>
                  <div class="form-row">
                    <div class="form-group ml-2 icheck-primary">
                      <input type="radio" class="" checked name="Situacao" id="rgTodos">
                      <label class="form-check-label pr-1" for="rgTodos">Todos</label>
                    </div>
                    <div class="form-group ml-2 icheck-primary">
                      <input type="radio" class="" name="Situacao" id="rgPendentes">
                      <label class="form-check-label pr-1" for="rgPendentes">Pendentes</label>
                    </div>
                    <div class="form-group ml-2 icheck-primary">
                      <input type="radio" class="" name="Situacao" id="rgCancelados">
                      <label class="form-check-label pr-1" for="rgCancelados">Cancelados</label>
                    </div>
                    <div class="form-group ml-2 icheck-primary">
                      <input type="radio" class="" name="Situacao" id="rgBaixados">
                      <label class="form-check-label pr-1" for="rgBaixados">Baixados</label>
                    </div>
                  </div>
                </fieldset>
              </div>

              <div class="form-group col-lg-4 col-12 col-sm-12">
                <label data-error="wrong" data-success="right" for="txtCheque">Cheque: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtCheque" name="txtCheque" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCheque" name="btnCheque" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaCheque" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="form-group col-lg-4 col-12 col-sm-12">
                <label data-error="wrong" data-success="right" for="txtBanco">Banco: </label>
                <div class="relative">
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtBanco" name="txtBanco" class="form-control" placeholder="Banco">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnBanco" name="btnBanco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaBanco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="form-group col-lg-4 col-12 col-sm-12">
                <label data-error="wrong" data-success="right" for="txtConta">Conta: </label>
                <div class="relative">
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtConta" name="txtConta" class="form-control" placeholder="Conta">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnConta" name="btnConta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaConta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="form-group col-lg-4 col-12 col-sm-12">
                <label data-error="wrong" data-success="right" for="txtFornecedor">Fornecedor: </label>
                <div class="relative">
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtFornecedor" name="txtFornecedor" class="form-control" placeholder="Fornecedor">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnFornecedor" name="btnFornecedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaFornecedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-md-2 col-12 mt-4 py-1 mb-3 mb-md-0">
                <button class="btn btn-danger btn-sisp w-100" type='button' id="btnSelecionarEmpresas">Selecionar Empresas</button>
              </div>

            </div>

            <!-- </div> -->
          </div>
        </div>
        <div class="modal-footer border-top d-flex justify-content-end align-items-end">
          <div class="mx-auto mx-md-0">
            <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
              <span class="fas fa-trash"></span> Limpar Filtros
            </button>
            <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
              <span class="fas fa-search"></span> Consultar
            </button>
          </div>
        </div>
      </div>

    </div>
  </div>

  <div id="modalCancelar" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title">Cancelar</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="group-default form-group">
              <label data-error="wrong" data-success="right" for="txtMotivo">Motivo: </label>
              <textarea type="textarea" style="resize: none" placeholder="Motivo" class="input-default focus form-control validate" id="txtMotivo" name="txtMotivo" required="required" rows="3"></textarea>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <button class="btn btn-danger btn-sisp" id="btnFecharCancelar"><i class="fas fa-times"></i> Desistir</button>     
            <button class="btn btn-primary btnSuccess btn-sisp" id="btnConfirmar"><i class="fas fa-check"></i> Confirmar</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../../modais.php');
  include_once('../../../modals/modal_anexos.html');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.258.28.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.258.28.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.258.28.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.258.28.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.258.28.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.258.28.1"></script>
  <script src="dist/js/sisplan.js?versao=3.258.28.1"></script>
  <script src="utils/funcoes.js?versao=3.258.28.1"></script>
  <script src="utils/cookies.js?versao=3.258.28.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.258.28.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.258.28.1"></script>
  <script src="dist/js/driver.min.js?versao=3.258.28.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.258.28.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.258.28.1"></script>
  <script type="text/javascript" src="config.js?versao=3.258.28.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.258.28.1"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.258.28.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.258.28.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.258.28.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('CHEQUEEMI');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/chequeemi/acesso_chequeemi/acesso_chequeemi.js?versao=3.258.28.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>