$('#tutorial').on('click', function () {
    $('#geral-tab').trigger('click');
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == 'geral') {
                    if (!$('#DadosGerais').hasClass('show'));
                    $('#DadosGerais').collapse('show');
                }
            },
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    $('#avancar1').trigger('click');
                };
                if ((Element.node.id == 'avancar2')) {
                    $('#avancar2').trigger('click');
                };
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'contas') {
                    $('#voltar').trigger('click');
                }
                if (Element.node.id == 'tipoDep') {
                    $('#voltar2').trigger('click');
                }
                if (Element.node.id == 'configuracao') {
                    $('#voltar3').trigger('click');
                }
            }

        });

        driver.defineSteps([{
            element: '#divGeral',
            popover: {
                title: 'Dados de Cadastro Geral',
                description: 'Esses são os campos que você informará os dados gerais de cadastro.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigoMarkup',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricaoMarkup',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "top",
            },
        }
        ]);

        driver.start();
    });
});

$(document).ready(async function () {
    function ajustaTabelas() {
        $("#tabelaEstados").DataTable().columns.adjust().draw(false);
    }

    $('#btnVoltar').on('click', async function () {
        window.location.href = `${BASE_URI}/chequeemi`;
    });

    adicionaPesquisa()

    $('#btnSelecionarEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    $(document).ready(async function () {
        let currentFs; let nextFs; let previousFs;
        let opacity;

        $(".next").click(function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {

                currentFs = $(this).parent();
                nextFs = $(this).parent().next();

                $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

                nextFs.show();
                currentFs.animate({
                    opacity: 0
                }, {
                    step(now) {
                        opacity = 1 - now;

                        currentFs.css({
                            'display': 'none',
                            'position': 'relative'
                        });
                        nextFs.css({
                            'opacity': opacity
                        });
                    },
                    duration: 600
                });
            }

            ajustaTabelas();
        });

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtConta: {
                    required: true,
                },
                txtNumero: {
                    required: true,
                },
                txtClasse: {
                    required: true,
                },
                txtHistorico: {
                    required: true,
                },
                txtSituacao: {
                    required: true,
                },
                txtFornecedor: {
                    required: true,
                }
            },
            messages: {
                txtConta: {
                    required: "Informe uma conta válida.",
                },
                txtNumero: {
                    required: "Informe um número de cheque."
                },
                txtClasse: {
                    required: 'Informe uma classe gerencial válida.',
                },
                txtHistorico: {
                    required: 'Informe um histórico válido',
                },
                txtSituacao: {
                    required: 'Informe uma situação válida.',
                },
                txtFornecedor: {
                    required: 'Informe um fornecedor valido.',
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $(".previous").click(function () {
            currentFs = $(this).parent();
            previousFs = $(this).parent().prev();
            $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
            previousFs.show();
            currentFs.animate({
                opacity: 0
            }, {
                step(now) {
                    opacity = 1 - now;
                    currentFs.css({
                        'display': 'none',
                        'position': 'relative'
                    });
                    previousFs.css({
                        'opacity': opacity
                    });
                },
                duration: 600
            });
        });
    });

    $('.checkSituacao').on('change', function () {
        if ($('#rgPagtoSimples').is(':checked')) {

            $('#divAps').addClass('d-none')
            $('#divAntecipacao').addClass('d-none')
            $('#divDeposito').addClass('d-none')
            $('#divBaixaSimples').removeClass('d-none')

            $('#txtValor').prop('disabled', false)
            $('#btnConsultar').prop('disabled', true)
            $('#txtValor').val('0.00')

        } else if ($('#rgValorDeposito').is(':checked')) {

            $('#divAps').addClass('d-none')
            $('#divBaixaSimples').addClass('d-none')
            $('#divAntecipacao').addClass('d-none')
            $('#divDeposito').removeClass('d-none')
            
            $('#txtValor').prop('disabled', false)
            $('#btnConsultar').prop('disabled', true)
            $('#txtValor').val('0.00')

        } else if ($('#rgPagtoAntecipacao').is(':checked')) {

            $('#divAps').addClass('d-none')
            $('#divBaixaSimples').addClass('d-none')
            $('#divDeposito').addClass('d-none')
            $('#divAntecipacao').removeClass('d-none')
            
            $('#txtValor').prop('disabled', false)
            $('#btnConsultar').prop('disabled', true)
            $('#txtValor').val('0.00')

        } else{

            $('#divAps').removeClass('d-none')
            $('#divBaixaSimples').addClass('d-none')
            $('#divDeposito').addClass('d-none')
            $('#divAntecipacao').addClass('d-none')

            $('#txtValor').prop('disabled', true)
            $('#btnConsultar').prop('disabled', false)
            calculaValorCheque()

        }
    })

    $('#txtConta').on('blur', async function () {
        if ($(this).val() == '') {
            return
        }
        $.LoadingOverlay('show')
        try {
            const pesquisaParam = {
                tabela: 'CADCONTA',
                camposSelect: ['CADCONTA.BANCO', 'CADBAN.NOME_BANCO'],
                leftJoin: [{ tabela: 'CADBAN', condicao: `CADBAN.BANCO = CADCONTA.BANCO` }],
                where: [`CADCONTA.CONTA = '${pegaChave('#txtConta')}'`]
            }

            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

            if (jsonStr.length > 0 && jsonStr[0].BANCO != '') {
                insereValor('#txtBanco', jsonStr[0].BANCO, jsonStr[0].NOME_BANCO);
            }

            await retornaProximoNumero()

            if ($('#txtNumero').val() != '' && $('#txtConta').val() != '') {
                await validaCheque()
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#txtNumero').on('blur', async function () {
        $.LoadingOverlay('show')
        try {
            if ($(this).val() == '') {
                await retornaProximoNumero()
            }

            if ($('#txtNumero').val() != '' && $('#txtConta').val() != '') {
                await validaCheque()
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }

    })

    $('#txtFornecedor').on('focusout', function () {
        if ($(this).val() == '') {
            return
        }

        $('#txtObservacao').val(`PAGTO DE CHEQUE A ${pegaDescricao('#txtFornecedor')}`)
        insereValor('#txtFornecedorPesquisa', pegaChave('#txtFornecedor'), pegaDescricao('#txtFornecedor'))
    })

    async function validaCheque() {
        $.LoadingOverlay('show')
        try {
            const pesquisaParam = {
                tabela: 'PAGTO',
                camposSelect: ['DUPLI'],
                where: [`CONTA = '${pegaChave('#txtConta')}' AND DUPLI = '${pegaValor('#txtNumero')}' AND STATUS = 'CHEQ'`]
            }

            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

            if (jsonStr.length > 0 && jsonStr[0].DUPLI != '') {
                msgAlerta('Cheque já gerado!')
                $('#txtNumero').val('')
                return;
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function retornaProximoNumero() {
        let vProx = "";
        let iProx;

        function somenteNumeros(valor) {
            return parseInt(valor.replace(/\D/g, "")) || 0;
        }

        const pesquisaParam = {
            tabela: 'PAGTO',
            camposSelect: ['MAX(LANCAMENTO) AS CHAVE'],
            where: [`CONTA = '${pegaChave('#txtConta')}' AND BANCO = '${pegaChave('#txtBanco')}' AND STATUS = 'CHEQ'`]
        }

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        iProx = somenteNumeros(await buscaValor("PAGTO", "LANCAMENTO", "DUPLI", jsonStr[0].DUPLI));
        iProx += 1;
        vProx = iProx.toString().padStart(6, '0');

        while (await Existe("PAGTO", ["CONTA", "BANCO", "DUPLI"], [pegaChave('#txtConta'), pegaChave('#txtBanco'), vProx])) {
            iProx += 1;
            vProx = iProx.toString().padStart(6, '0');
        }

        $('#txtNumero').val(vProx)
    }

    async function retornaFiltros() {
        const empresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : [getCookie('emp_id')]

        const filtros = `DTVENCIMENTODE=${$('#txtDtVencimentoI').val()}` +
            `&DTVENCIMENTOATE=${$('#txtDtVencimentoF').val()}` +
            `&DTEMISSAODE=${$('#txtDtEmissaoI').val()}` +
            `&DTEMISSAOATE=${$('#txtDtEmissaoF').val()}` +
            `&NUMAP=${await formataListas($('#txtNumeroAp').val().toString())}` +
            `&CLASSE=${pegaChave('#txtClassePesquisa')}` +
            `&EMPRESAS=${await formataListas(empresas.toString())}` +
            `&FORNECEDOR=${pegaChave('#txtFornecedorPesquisa')}` +
            `&PESQUISAMOV=S`;

        return filtros
    }

    $('#btnConsultar').on('click', async function () {
        if ($.fn.DataTable.isDataTable('#tabelaCheques')) {
            $('#tabelaCheques').DataTable().destroy();
            $('#tabelaCheques').empty();
        }
        $.LoadingOverlay('show')
        try {
            const filtros = await retornaFiltros()
            await pesquisaAps(filtros)
            await pesquisaCheques(filtros)
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function pesquisaCheques(filtros) {
        const url = "/sisplan/chequeemi/v1/buscaacesso?"
        const response = await requisicao('GET', url, filtros, null, 180000);

        if (!response) {
            return;
        }

        const jsonStr = await response.json();

        if (response.status != 200) {
            throw new Error(jsonStr.mensagem);
        }

        if (jsonStr.length <= 0) {
            return
        }

        await montaDataTableCheque(jsonStr)
    }

    async function montaDataTableCheque(jsonStr) {
        const keys = Object.keys(jsonStr[0]);
        let dataSetCols = [];

        for (var k in keys) {
            dataSetCols.push({
                'title': keys[k].toUpperCase(),
                'data': keys[k]
            });
        };

        $('#tabelaCheques').DataTable({
            bPaginate: true,
            search: false,
            destroy: true,
            colReorder: true,
            order: [],
            info: true,
            pageLength: 5,
            lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
            filter: false,
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    type: "date-br",
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        } else {
                            return ''
                        }
                    },
                    targets: [1, 2]
                },
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            minimumFractionDigits: 2,
                        });
                    },
                    targets: [3],
                    "className": 'pr-4 text-right'
                }
            ]
        });

        if (jsonStr.length > 0) {
            $('#tabelaCheques tbody tr').eq(0).click();
        }
    }

    $('#tabelaCheques').on('click', 'tr', async function () {
        $.LoadingOverlay('show')
        try {
            let lancamento = 0;

            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                $('#tabelaCheques').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                lancamento = $('#tabelaCheques').DataTable().row($(this)).data().LANCAMENTO
            }

            if (lancamento > 0) {
                await buscaBaixas(lancamento)
            } else {
                if ($.fn.DataTable.isDataTable('#tabelaBaixas')) {
                    $('#tabelaBaixas').DataTable().destroy();
                    $('#tabelaBaixas').empty();
                }
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function buscaBaixas(lancamento) {
        if ($.fn.DataTable.isDataTable('#tabelaBaixas')) {
            $('#tabelaBaixas').DataTable().destroy();
            $('#tabelaBaixas').empty();
        }
        $.LoadingOverlay('show')
        try {
            const url = "/sisplan/chequeemi/v1/buscarbaixas?"
            const response = await requisicao('GET', url, `LANCAMENTO=${lancamento}`, null, 180000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            if (response.status != 200) {
                throw new Error(jsonStr.mensagem);
            }

            if (jsonStr.length <= 0) {
                return
            }

            await montaDataTableBaixas(jsonStr)

        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function montaDataTableBaixas(jsonStr) {
        const keys = Object.keys(jsonStr[0]);
        let dataSetCols = [];

        for (var k in keys) {
            dataSetCols.push({
                'title': keys[k].toUpperCase(),
                'data': keys[k]
            });
        };

        $('#tabelaBaixas').DataTable({
            bPaginate: true,
            search: false,
            destroy: true,
            colReorder: true,
            order: [],
            info: true,
            pageLength: 5,
            lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
            filter: false,

            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    type: "date-br",
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        } else {
                            return ''
                        }
                    },
                    targets: [2, 4]
                },
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            minimumFractionDigits: 2,
                        });
                    },
                    targets: [5, 6, 7],
                    "className": 'pr-4 text-right'
                }
            ]
        });
    }

    async function pesquisaAps(filtros) {
        if ($.fn.DataTable.isDataTable('#tabelaAp')) {
            $('#tabelaAp').DataTable().destroy();
            $('#tabelaAp').empty();
        }
        $.LoadingOverlay('show')
        try {
            const url = "/sisplan/chequeemi/v1/buscaraps?"
            const response = await requisicao('GET', url, filtros, null, 180000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            if (response.status != 200) {
                throw new Error(jsonStr.mensagem);
            }

            if (jsonStr.length <= 0) {
                throw new Error('Nenhuma AP encontrada!')
            }

            await montaDataTableAps(jsonStr)
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    function retornaInputValor(sNomeInput, iIndex = 0, data) {
        return `<input type="text" class="input-default focus form-control camposMascaraQtde ${sNomeInput}" data-campo="${sNomeInput}" data-index="${iIndex}" id="${sNomeInput}${iIndex}" value="${data}">`
    };

    async function montaDataTableAps(jsonStr) {
        const keys = Object.keys(jsonStr[0]);
        let dataSetCols = [];

        for (var k in keys) {
            dataSetCols.push({
                'title': keys[k].toUpperCase(),
                'data': keys[k]
            });
        };

        dataSetCols[0].render = function (data, type, row, meta) {
            return '<div class="form-check pl-0">' +
                '<div class="icheck-primary">' +
                `<input style="height:20px" type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="align-self-center campoCheck"><label for="check_col_${meta.row}_row_${meta.col}"></label>` +
                '</div>' +
                '</div>';
        }

        dataSetCols[7].render = function (data, type, row, meta) {
            return retornaInputValor('txtValorCheque', meta.row, data)
        }

        dataSetCols[9].render = function (data, type, row, meta) {
            return retornaInputValor('txtJuros', meta.row, data)
        }

        const tabela = $('#tabelaAp').DataTable({
            bPaginate: true,
            search: false,
            destroy: true,
            colReorder: true,
            order: [],
            info: true,
            pageLength: 5,
            lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
            filter: false,
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    type: "date-br",
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        } else {
                            return ''
                        }
                    },
                    targets: [4, 5, 13]
                },
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            minimumFractionDigits: 2,
                        });
                    },
                    targets: [6, 8, 15, 16],
                    "className": 'pr-4 text-right'
                }
            ]
        });

        $('#tabelaAp').on('click', '.campoCheck', async function () {
            const row = parseInt(this.id.split('col_')[1].split('_row')[0])
            if (this.checked) {
                $('#tabelaAp').DataTable().rows(row).data()[0].BAIXAR = 'S'
                $(this).parents('tr').addClass('selected')
            } else {
                $('#tabelaAp').DataTable().rows(row).data()[0].BAIXAR = 'N'
                $(this).parents('tr').removeClass('selected')
            }

            calculaValorCheque()
        });

        $('#tabelaAp').on('change', '.camposMascaraQtde', async function () {
            calculaValorCheque()
        })

        tabela.on('draw', function () {
            aplicaMascara()
        })

        aplicaMascara()
    }

    function calculaValorCheque() {
        if (!$.fn.DataTable.isDataTable('#tabelaAp')) {
            $('#txtValor').prop('disabled', true);
            $('#txtValor').val('0.00');
            $('#txtTotal').val('0.00');
            return
        }

        const tabela = $('#tabelaAp').DataTable();
        const dadosTabela = tabela.data().toArray();

        let totalCheque = 0;
        let hasSelected = false;

        tabela.rows().nodes().each(function (row, index) {
            const item = dadosTabela[index];
            let valor = parseFloat($(row).find(`.txtValorCheque`).val()) || 0;
            const juros = parseFloat($(row).find(`.txtJuros`).val()) || 0;

            if (item.BAIXAR == 'S') {
                hasSelected = true;
                valor = valor <= 0 ? parseFloat(item.VALOR) : valor;
                totalCheque += valor + juros;
            }
        });

        $('#txtValor').prop('disabled', !hasSelected);
        $('#txtValor').val(totalCheque.toFixed(2));
        $('#txtTotal').val(totalCheque.toFixed(2));
    }


    async function validacoes() {
        let error = false
        if (isNaN(parseFloat($('#txtValor').val())) || parseFloat($('#txtValor').val()) <= 0) {
            throw new Error('O valor deve ser maior que R$0,00!')
        }

        if ($('#rgPagtoSimples').is(':checked') && parseInt($('#txtQtdeCheques').val()) <= 0) {
            throw new Error('Quantidade de cheques inválida!')
        }

        if ($('#rgPagtoAntecipacao').is(':checked') && $('#txtHistoricoAnte').val() == '') {
            throw new Error('Historico da antecipação não informado!')
        }

        if ($('#rgValorDeposito').is(':checked') && $('#txtContaDep').val() == '') {
            throw new Error('Conta para depósito não informado!')
        }

        if ((!$('#rgPagtoSimples').is(':checked')) && parseFloat($('#txtValor').val()) > parseFloat($('#txtTotal').val())) {
            await msgAguardaConfirmacao('Valor dos cheques é diferente do valor das aps selecionadas. Continuar mesmo assim?', async () => { }, async () => {
                error = true
            })

            if (error) {
                throw new Error('Operação cancelada!')
            }
        }

        error = false

        if ($('#rgPagtoAp').is(':checked')) {
            await msgAguardaConfirmacao('Essa Operação irá Baixar as Duplicatas, Lançar o Cheque e Debitar o Valor da Conta Corrente. Continuar mesmo assim?', async () => { }, async () => {
                error = true
            })

            if (error) {
                throw new Error('Operação cancelada!')
            }
        }
    }

    $('#btnGravar').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            await validacoes()
            await gravaCheque()
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    function retornaAps() {
        const aps = []

        if ($('#rgPagtoAp').is(':checked')){
            for (let i = 0; i < $('#tabelaAp').DataTable().data().toArray().length; i++) {
                const item = $('#tabelaAp').DataTable().data().toArray()[i];
    
                if (item.BAIXAR == 'S') {
                    const objAp = {
                        NUMAP: item.NUM_AP,
                        VALOR: item.VALOR,
                        VALORCHEQUE: parseFloat($($(`.txtValorCheque`)[i]).val()) || 0,
                        JUROS: parseFloat($($(`.txtJuros`)[i]).val()) || 0,
                        FORNECEDOR: item.CODCRE,
                        EMPRESA: item.EMPRESA,
                    }
    
                    aps.push(objAp)
                }
            }
        }

        return aps
    }

    async function gravaCheque() {
        $.LoadingOverlay('show')
        try {
            const total = parseFloat(pegaValor('#txtTotal')) || 0
            const obj = {
                NUMERO: pegaValor('#txtNumero'),
                PENDENTE: $('#cbPendente').is(':checked') ? 'S' : 'N',
                EMISSAO: pegaValor('#txtEmissao'),
                VENCIMENTO: pegaValor('#txtVencimento'),
                CONTA: pegaChave('#txtConta'),
                BANCO: pegaChave('#txtBanco'),
                CLASSE: pegaChave('#txtClasse'),
                HISTORICO: pegaChave('#txtHistorico'),
                SITUACAO: pegaChave('#txtSituacao'),
                FORNECEDOR: pegaChave('#txtFornecedor'),
                NOME: pegaDescricao('#txtFornecedor'),
                OBS: pegaValor('#txtObservacao'),
                TIPO: $('#rgPagtoAntecipacao').is(':checked') ? 1 : $('#rgPagtoSimples').is(':checked') ? 2 : $('#rgValorDeposito').is(':checked') ? 3 : 0,
                VALOR: parseFloat(pegaValor('#txtValor')),
                TOTAL: total <= 0 ? parseFloat(pegaValor('#txtValor')) : total,
                QTDECHEQUES: parseInt(pegaValor('#txtQtdeCheques')),
                INTERVALO: parseInt(pegaValor('#txtIntervaloDias')),
                HISTORICOANTE: pegaChave('#txtHistoricoAnte'),
                CONTADEP: pegaChave('#txtContaDep'),
                APS: retornaAps()
            }

            let response = await requisicao("POST", "/sisplan/chequeemi/v1/criacheque?", null, encodeURIComponent(JSON.stringify(obj)), 360000);

            if (!response) {
                return;
            }
            if (response.status != 200) {
                let jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }

            toastr.success(`Cheque criado com sucesso! Número: ${obj.NUMERO}`, "Confirmação", {
                toastClass: "success",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    window.location.href = `${BASE_URI}/chequeemi`;
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    function adicionaPesquisa() {
        componenteFiltro('conta', false, false)
        componenteFiltro('classe', false, false)
        componenteFiltro('historico', false, false)
        componenteFiltro('situacao', false, false)
        componenteFiltro('entidade', false, false, 'Fornecedor')
        componenteFiltro('entidade', false, false, 'FornecedorPesquisa')
        componenteFiltro('classe', false, false, 'ClassePesquisa')
        componenteFiltro('historico', false, false, 'HistoricoAnte')
        componenteFiltro('conta', false, false, 'ContaDep')

        $('#txtNumeroAp').pesquisa_variosServerside(3, `{ 
            "tabela":"PAGTO", 
            "camposSelect": ["PAGTO.NUM_AP", "PAGTO.CODCRE"],
            "where": null}`,
            'NUM_AP', 'CODCRE');

        $('#btnNumeroAp').pesquisa_serversideSel('#txtNumeroAp', `{ 
            "tabela":"PAGTO", 
            "camposSelect": ["PAGTO.NUM_AP", "PAGTO.CODCRE", "ENTIDADE.NOME", "PAGTO.VALOR"], 
            "leftjoin":[{"tabela":"ENTIDADE", "condicao": "ENTIDADE.CODCLI = PAGTO.CODCRE"}],
            "where": null}`, 'Pesquisa Ap');

        $('#btnLimpaNumeroAp').on('click', function () {
            $('#txtNumeroAp').empty().trigger('change');
        });

        const dataAtual = retornaDataAtual()
        $('#txtEmissao').val(dataAtual)
        $('#txtVencimento').val(dataAtual)

        aplicaMascara()
    }

    function aplicaMascara() {
        $(".camposMascaraQtde").maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        $(".camposMascaraQtde").on('blur', function () {
            if (($(this).val() == '0.00') || ($(this).val() == '')) {
                $(this).val('0.00');
            }
        });

        $(".camposMascaraQtdeInteiro").maskMoney({
            decimal: ".",
            thousands: "",
            precision: 0,
        });

        $(".camposMascaraQtdeInteiro").on('blur', function () {
            if (($(this).val() == '0') || ($(this).val() == '')) {
                $(this).val('0');
            }
        });
    }

});