$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
      animate: true,
    });

    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#tutorialCodigo",
        popover: {
          title: "Código",
          description:
            "Aqui adicionamos o código para a Classificação Fiscal.",
          position: "top",
        },
      },
      {
        element: "#tutorialAtivo",
        popover: {
          title: "Ativo",
          description:
            "Aqui selecionamos se estará ativa.",
          position: "top",
        },
      },
      {
        element: "#tutorialPadrao",
        popover: {
          title: "Padrão",
          description:
            "Aqui selecionamos se será a Classificação Padrão, poderá ter apenas uma classificação como padrão.",
          position: "top",
        },
      },
      {
        element: "#tutorialNCM",
        popover: {
          title: "NCM",
          description:
            "Neste campo adicionamos o Código NCM.",
          position: "top",
        },
      },
      {
        element: "#tutorialTipo",
        popover: {
          title: "Tipo",
          description:
            "Neste campo podemos informar o tipo da Classificação.",
          position: "top",
        },
      },
      {
        element: "#tutorialObservacao",
        popover: {
          title: "NCM",
          description:
            "Aqui adicionamos uma observação sobre esta classificação.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#gravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o cadastro.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  $("#checkAtivo").attr("checked", true);

  $("#txtCodigo").prop("disabled", true);

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let clafiscal = parametros[parametros.length - 1];

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("CLAFISCAL", getCookie("usuario"), clafiscal);
    window.location.href = `${BASE_URI}/clafiscal`;
  });

  function validarCaracteres(valor) {
      const regex = /[\/%?!\"*<>|]/g;
      return valor.replace(regex, '');
  }

  $('.validarCaractere').on('input', function () {
    const valLimpo = validarCaracteres($(this).val())
    $(this).val(valLimpo)
  })

  $(document).ready(function () {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtDescricao: {
          required: true,
        },
      },
      messages: {
        txtDescricao: {
          required: "Informe uma descrição válida.",
        },
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });

    $(".radio-group .radio").click(function () {
      $(this).parent().find(".radio").removeClass("selected");
      $(this).addClass("selected");
    });

    $(".submit").click(function () {
      return false;
    });
  });

  $("#txtCest").autocompleta(1, `JSON={ "tabela":"CADCEST", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
  $("#btn-Cest").pesquisa("#txtCest", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCEST", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', "Pesquisa CEST", "CADCEST");
  $("#btn-limpa-Cest").on("click", function () { $("#txtCest").val(""); });

  $("#checkPadrao").on("click", async function () {
    if ($("#checkPadrao").prop("checked")) {
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"tabfis", "camposSelect":["codigo,padrao"], "where":[" PADRAO = 'S' "]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }
        if (jsonStr.RESULT[0].length != 0) {
          $("#checkPadrao").trigger("click");
          $("#checkPadrao").attr("checked", false);
          msgAlerta(`O NCM ${jsonStr.RESULT[0][0].CODIGO} já está como padrão`);
        }
      } catch (error) {
        console.error(error);
      }
    }
  });

  if (clafiscal != "" && clafiscal != "create") {
    if ((await liberarRegistro("CLAFISCAL", clafiscal)) == false) {
      window.location.href = "../clafiscal";
    } else {
      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"tabfis", 
                    "camposSelect":["codigo", "descricao", "padrao", "tipo", "observacao", "ativo", "cest"], 
                    "where": ["codigo = '${clafiscal}'"]}`,
            null
          );

          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          $("#txtCodigo").attr("readonly", true);

          $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
          $("#txtDescricao").val(jsonStr.RESULT[0][0].DESCRICAO);
          $("#txtTipo").val(jsonStr.RESULT[0][0].TIPO);
          $("#txtObs").val(jsonStr.RESULT[0][0].OBSERVACAO);

          if (jsonStr.RESULT[0][0].CEST != '') {
            insereValor('#txtCest', jsonStr.RESULT[0][0].CEST, (await buscaValor("CADCEST", "DESCRICAO", "CODIGO", jsonStr.RESULT[0][0].CEST)).DESCRICAO);
          }

          if (jsonStr.RESULT[0][0].PADRAO == "S") {
            $("#checkPadrao").prop("checked", true);
          } else {
            $("#checkPadrao").prop("checked", false);
          }

          if (jsonStr.RESULT[0][0].ATIVO == "S") {
            $("#checkAtivo").prop("checked", true);
          } else {
            $("#checkAtivo").prop("checked", false);
          }
        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados do tamanho: ${error}`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
  }

  $("#gravar").click(async function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      try {
        $.LoadingOverlay("show");

        let clafiscalClasse = {};

        clafiscalClasse.CODIGO =
          $("#txtCodigo").val() == ""
            ? await RetornaProximo("TABFIS", "TABFIS", "CODIGO", 5)
            : $("#txtCodigo").val();
        clafiscalClasse.DESCRICAO = $("#txtDescricao").val().toUpperCase();
        clafiscalClasse.TIPO = $("#txtTipo").val().toUpperCase();
        clafiscalClasse.OBSERVACAO = $("#txtObs").val().toUpperCase();
        clafiscalClasse.CEST = pegaChave('#txtCest');

        if ($("#checkPadrao").prop("checked")) {
          clafiscalClasse.PADRAO = "S";
        } else {
          clafiscalClasse.PADRAO = "N";
        }

        if ($("#checkAtivo").prop("checked")) {
          clafiscalClasse.ATIVO = "S";
        } else {
          clafiscalClasse.ATIVO = "N";
        }

        let response = await requisicao(
          "POST",
          "/Sisplan/Cadastros/v1/clafiscal?",
          `JSON=${encodeURIComponent(JSON.stringify(clafiscalClasse))}`,
          null
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success(
            `Cadastro efetuado com sucesso!
                         Classificação fiscal: ${clafiscalClasse.CODIGO}`,
            "Confirmação",
            {
              toastClass: "alert",
              iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 5000,
              fadeOut: 3000,
              onHidden() {
                window.location.href = `${BASE_URI}/clafiscal`;
              },
            }
          )
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
      }
    }
  });
});
