$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btn-filtros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os campos disponíveis de filtro.',
                position: 'right'
            }
        },
        {
            element: '#collapseFiltros',
            popover: {
                title: 'Filtros Disponíveis',
                description: 'Filtre os dados conforme sua necessidade.',
                position: 'top'
            }
        },
        {
            element: '#tabelaRegistros_wrapper',
            popover: {
                title: 'Registros bloqueados',
                description: 'Aqui você verá os registros bloqueados, ou seja, que ficaram presos por algum usuário.',
                position: 'top'
            }
        },
        {
            element: '#btn-liberar',
            popover: {
                title: 'Botão Liberar',
                description: 'Aqui você efetuará a liberação dos registros selecionados na lista.',
                position: 'top'
            }
        }
        ]);
        //inicio tour

        driver.start();

        // inicior tuor
        //final
    });
});
$(document).ready(async function () {

    $('#txtUsuario').autocompleta(1, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo chave", "NOME descricao"], "where": ["CODIGO <> '9999'"]}`);
    $('#btnUsuario').pesquisa('#txtUsuario', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo", "NOME"], "where": ["CODIGO <> '9999'"]}`, 'Pesquisa Usuário', 'ACESSO_USUARIOS');
    $('#btnLimparUsuario').on('click', function () {
        $('#txtUsuario').val('');
    });

    $('#txtDashboard').autocompleta(1, `JSON={ "tabela":"DASH_WEB", "camposSelect":[ "ID chave", "NOME descricao"]}`);
    $('#btnDashboard').pesquisa('#txtDashboard', 'ID', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DASH_WEB", "camposSelect":[ "ID", "NOME"]}`, 'Pesquisa Usuário', 'DASH_WEB');
    $('#btnLimparDashboard').on('click', function () {
        $('#txtDashboard').val('');
    });

    async function buscaRegistros() {
        try {
            $.LoadingOverlay("Show");
            try {
                const usuario = $('#txtUsuario').val() !== '' ? ` AND ACESSO_USUARIOS.CODIGO = '${pegaChave('#txtUsuario')}'` : '';
                const dashboard = $('#txtDashboard').val() !== '' ? ` AND DASH_WEB.ID = ${pegaChave('#txtDashboard')}` : '';
                const pesquisa = {
                    tabela: 'ACESSO_USUARIOS',
                    camposSelect: ['(SELECT MAX(CONSULTA) CONSULTA FROM [DASH_ACESSO_WEB] DASH_ACESSO_WEB WHERE DASH_ACESSO_WEB.ID_DASH = DASH_WEB.ID AND DASH_ACESSO_WEB.CODIGO = ACESSO_USUARIOS.CODIGO) CONSULTA',
                        'ACESSO_USUARIOS.CODIGO', 'ACESSO_USUARIOS.NOME', 'DASH_WEB.ID ID_DASH', 'DASH_WEB.NOME NOME_DASH'],
                    leftJoin: [{ tabela: 'DASH_WEB', condicao: '1 = 1' }],
                    where: [`ACESSO_USUARIOS.CODIGO <> '9999' ${usuario} ${dashboard}`]
                }
                //adicionar where dos filtros
                const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
                return json;

            } catch (error) {
                console.error(error);
                msgErro('Não foi possível buscar os dados do produto.');
            }
        } finally {
            $.LoadingOverlay("Hide");
        }
    }

    async function gravaAcesso(objeto) {
        try {
            const url = `/sisplan/dashboard/v1/acesso_dashboard?CODUSUARIO=${pegaChave('#txtUsuario')}&`;
            var response = await requisicao('POST', url, `JSON=${encodeURIComponent(JSON.stringify(objeto))}`, null);

            if (!response) {
                return false;
            }

            if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem);
                return false;
            }
            return true;
        } catch (error) {
            console.error(error);
            return false;
        }
    }

    $('#btn-liberar').on('click', async function () {
        const registros = [];
        for (let i = 0; i < $('#tabelaRegistros').DataTable().rows().count(); i++) {
            const dados = $('#tabelaRegistros').DataTable().row(i).data();
            const registro = {
                ID_DASH: dados.ID_DASH,
                CODIGO: dados.CODIGO,
                CONSULTA: dados.CONSULTA
            }
            if (registro.CONSULTA == 'S') { registros.push(registro); }
        }
        const objeto = {
            acessos: registros
        }
        const gravadoComSucesso = await gravaAcesso(objeto);
        if (gravadoComSucesso) {
            msgSucesso('Processo concluído');
        } else {
            msgErro('Erro ao liberar Acessos');
            return;
        }
        $('#btn-consultar').trigger('click');
    });

    $('#btnLimparFiltros').click(async function () {
        $('#txtUsuario').val('');
        $('#txtDashboard').val('');
    });

    $('#btn-consultar').on('click', async function () {
        var dataSet = await buscaRegistros();
        var dataSetCols = [];

        if (dataSet.length > 0) {
            var keys = Object.keys(dataSet[0]);
            for (var k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                });
            }
            dataSetCols[0] = { ...dataSetCols[0], width: '20px' }
            dataSetCols[0].render = function (data, type, row, meta) {
                const estaLiberado = row.CONSULTA === 'S';
                return '<div class="group-default form-group">' +
                    '<div class="relative">' +
                        `<div class="icheck-primary"><input ${estaLiberado ? 'checked= "checked"' : ''} style="height:20px" type="checkbox" id="check_col_${[meta.row]}_row_${meta.col}" class="input-default focus form-control validate campoCheck ${estaLiberado ? 'selecionado' : ''}"><label for="check_col_${[meta.row]}_row_${meta.col}"></label></div> ` +
                    '</div>' +
                    '</div>';

            }


            $('#tabelaRegistros').DataTable({
                paging: true,
                filter: true,
                info: false,
                order: false,
                destroy: true,
                "data": dataSet,
                "columns": dataSetCols,
                "columnDefs": [{
                    className: "dt-head-center"
                }]
            });
        } else {
            $('#tabelaRegistros').DataTable({
                autoWidth: true,
                destroy: true,
                "scrollCollapse": true,
                "data": dataSet,
                "columnDefs": [{
                    className: "dt-head-center"
                }]
            });
        }
        $('#tabelaRegistros')
            .on('draw.dt', funcaoChangeCheck)
            .dataTable();

        funcaoChangeCheck();
        $('#modal-filtros').modal('hide');
    });

    function funcaoChangeCheck() {
        $('.campoCheck').unbind('change');
        $('.campoCheck').on('change', function () {
            const tr = this.closest('tr');
            const consulta = this.checked ? 'S' : 'N';
            const dados = $('#tabelaRegistros').DataTable().row($(tr)).data();
            const novosDados = { ...dados, CONSULTA: consulta }
            $('#tabelaRegistros').DataTable().row($(tr)).data(novosDados);
            if (this.checked) {
                $(this).addClass('selecionado');
            } else {
                $(this).removeClass('selecionado');
            }
        });
    }

    $('#btn-consultar').trigger('click');
});