$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: 'O campo de código é preenchido automaticamente após gravar o registro.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para a espécie.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a espécie.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let especie = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('ESPECIE', getCookie('usuario'), especie);
        window.location.href = `${BASE_URI}/especie`;
    });

    $(document).ready(function () {

        $('#txtCodigo').prop('disabled', true);

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    if (especie != '' && especie != 'create') {

        if (await liberarRegistro('ESPECIE', especie) == false) {
            window.location.href = '../especie';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response1 = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"especie", 
                    "camposSelect":["codigo", "descricao"], 
                    "where": ["codigo = '${especie}'"]}`, null);

                    if (!response1) {
                        return;
                    }
                    let jsonStr1 = await response1.json();
                    if (response1.status != 200) {
                        msgErro(jsonStr1.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtCodigo').val(jsonStr1.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr1.RESULT[0][0].DESCRICAO);

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do tamanho: ${error}`);
                }
            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $("#gravar").click(

        async function () {

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    let especieClasse = {};

                    especieClasse.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('ESPECIE', 'ESPECIE', 'CODIGO', 2) : $('#txtCodigo').val();
                    especieClasse.DESCRICAO = $('#txtDescricao').val().toUpperCase();

                    let response2 = await requisicao('POST', '/Sisplan/Cadastros/v1/especie?', `JSON=${encodeURIComponent(JSON.stringify(especieClasse))}`, null);

                    if (!response2) {
                        return;
                    };

                    let jsonStr2 = await response2.json();

                    if (response2.status != 200) {
                        msgErro(jsonStr2.mensagem);
                        return;
                    }

                    toastr.success(
                        `Cadastro efetuado com sucesso!
                        Espécie: ${especieClasse.CODIGO}`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/especie`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível gravar os dados da espécie: ${error}`);
                } finally {
                    $.LoadingOverlay("hide");
                }
            }
        });
});