$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovaOperadora',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de uma operação fiscal.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaInfoTef',
                popover: {
                    title: 'Tabela Regras',
                    description: 'Aqui estão os dados das operações fiscais cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("OPERADORATEF");

    $('#txtEmpAdmin').autocompleta(4, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
    $('#btnEmpAdmin').pesquisa('#txtEmpAdmin', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI", "NOME"]}`, 'Pesquisa Entidade', 'ENTIDADE');
    $('#btnAEmpAdmin').on('click', function () {
        $('#txtEmpAdmin').val('');
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnNovaOperadora').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "operadoratef/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    function retornaBotaoOpcoes() {
        return '<div class="divBtnOpcoes"> ' +
            '    <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>      ' +
            '   </div>';
    }

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '</div>';
        return retorno;
    };

    consultaOperadora();

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaOperadora();
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtEmpAdmin').val('');
        $('#txtTaxaOp').val('');
        $('#txtOperadora').val('');
    });

    async function consultaOperadora() {
        try {
            $.LoadingOverlay("show");
            try {
                const empAdmin = pegaChave('#txtEmpAdmin');
                const operadora = $('#txtOperadora').val() != '' ? ` AND TEF_OPERADORA.OPERADORA = '${$('#txtOperadora').val()}'` : '';
                const taxa = $('#txtTaxaOp').val() != '' ? ` AND TEF_OPERADORA.TAXA = '${$('#txtTaxaOp').val()}'` : '';
                const empId = ` AND TEF_OPERADORA.EMP_ID = '${getCookie('emp_id')}'`;

                let responseEntidade = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ "tabela":"ENTIDADE", "camposSelect":["ID", "CODCLI", "CODCLI"], 
                "where": ["CODCLI = '${empAdmin}'"]}`, null);

                let jsonEntidade = await responseEntidade.json();

                const id_entidade = jsonEntidade.RESULT[0].length == 0 ? '' : ` AND TEF_OPERADORA.ID_ENT = '${jsonEntidade.RESULT[0][0].ID}'`;

                let response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"TEF_OPERADORA", "camposSelect":[ "TEF_OPERADORA.ID", "TEF_OPERADORA.ID_ENT", "TEF_OPERADORA.OPERADORA", "TEF_OPERADORA.TAXA", "ENTIDADE.NOME AS NOME_ENT"], 
                "leftjoin": [{ "tabela" : "ENTIDADE", "condicao" : "ENTIDADE.ID = TEF_OPERADORA.ID_ENT" }],  
                "where": ["1=1 ${id_entidade} ${operadora} ${taxa} ${empId}"]}`, null);

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
                if (colunasInvisiveis == null || colunasInvisiveis.acessoCadInfoTef == undefined) {
                    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadInfoTef: ['EMPRESA'] }));
                    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
                }

                $('#tabelaInfoTef').DataTable({
                    destroy: true,
                    lengthChange: true,
                    paging: true,
                    searching: true,
                    scrollX: true,
                    scrollY: '350px',
                    "autoWidth": true,
                    "data": jsonStr.RESULT[0],
                    "columns": [{
                        data: "ID",
                        title: "ID"
                    },
                    {
                        data: "OPERADORA",
                        title: "Operadora"
                    },
                    {
                        data: "ID_ENT",
                        title: "ID Ent."
                    },
                    {
                        data: "NOME_ENT",
                        title: "Nome Ent."
                    },
                    {
                        data: "TAXA",
                        title: "Taxa"
                    },
                    ],
                    "columnDefs": [{
                        targets: [0], render: function (data, type, row) {
                            return retornaBotaoOpcoes(data);
                        }
                    }]
                });

                $('#tabelaInfoTef_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
                $('#tabelaInfoTef_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

                $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
                $('#buttonExcel').prop('title', 'Exportar')

                $('#buttonColVis').on('click', async function () {
                    $.LoadingOverlay('show');
                    $('#modal-ColunasVisiveis').modal('show');
                    $.LoadingOverlay('hide');
                });

                $('#buttonExcel').on('click', async function () {
                    const dados = $("#tabelaInfoTef").DataTable().data().toArray();
                    await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Informações do TEF', '', '', 999, false, false, dados);
                });

                $('#tabelaInfoTef').DataTable().columns().every(function () {
                    if ((colunasInvisiveis.acessoCadInfoTef).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                });

            } catch (error) {
                msgErro('Erro ao consultar as operadoras.');
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaInfoTef').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        adicionaColunas(cols, colunasInvisiveis.acessoCadInfoTef ?? ['EMPRESA']);
    });

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            removeColunasFixas(novasColunas, ["ID"]);
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadInfoTef: novasColunas }));

            $('#tabelaInfoTef').DataTable().columns().visible(true);

            $('#tabelaInfoTef').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

    $('#tabelaInfoTef').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaInfoTef').DataTable().row($(this).parents('tr')).data();
            var registroLiberado = await verificarRegistro('OPERADORATEF', data.ID)
            if (registroLiberado) {
                window.location.href = `operadoratef/${data.ID}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaInfoTef').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaInfoTef').DataTable().row($(this)).data();
            var registroLiberado = await verificarRegistro('OPERADORATEF', data.ID)
            if (registroLiberado) {
                window.location.href = `operadoratef/${data.ID}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

});