$(document).ready(async function () {
  let objOrcamento = []
  let objItens = {}
  let objSubItens = {}
  const orcamento = $(window.location.href.split('/')).get(-1);
  const paramsPedido = await BuscaParametrosPedido()
  const somarFreteCondicoes = paramsPedido[10].VALOR == '1';
  const parametrosComercial = await BuscaParametrosPedido();
  let itensAlteracao = []
  await setarDataAtual('dtDigitacao')
  let capaAtual = null;
  let itens = [];
  let tabelaItens;
  let tabelaSubItens;

  await adicionaEmpresas();
  criaMascaraCampos();
  await addBotoesAvancarVoltar();

  const columnsItens = [
    { "data": "id", "title": "Item" },
    { "data": "codigo", "title": "Cortina" },
    { "data": "cor", "title": "Cor" },
    { "data": "quantidade", "title": "Qtde." },
    { "data": "largura", "title": "Largura" },
    { "data": "altura", "title": "Altura" },
    { "data": "valorTotal", "title": "Valor Total" },
  ]

  const columnsSubItens = [
    { data: 'id', title: "Nº" },
    { data: 'codigo', title: "Código" },
    { data: 'tipoLT', title: "Tipo LT" },
    { data: 'tm', title: "TM" },
    { data: 'dimensao', title: "Dimensão" },
    { data: 'partes', title: "Partes" },
    { data: 'quantidade', title: "Qtd" },
    { data: 'un', title: "UM" },
    { data: 'valor', title: "Valor" },
    { data: 'valorTotal', title: "Valor Total" }
  ]

  const columnsHistorico = [
    { data: 'ID', title: "Nº" },
    { data: 'OCORRENCIA', title: "Ocorrência" },
    { data: 'USUARIO', title: "Usuário" },
    { data: 'DATA_HORA', title: "Data" }
  ]

  const botaoDinamico = {
    targets: [0],
    funcao: (data, type, row) => { return retornaBotaoOpcoes(data); }
  }
  criaDataTablePadrao('#tabelaCondicao', false, false, false, false, true, true, '250px', null, null, [], [], [], [5]);
  criaDataTablePadrao('#tabelaItens', false, false, false, false, true, true, '250px', null, columnsItens, [], [], [], [], botaoDinamico);
  criaDataTablePadrao('#tabelaSubItens', false, false, false, [[0, 'asc']], true, true, '250px', null, columnsSubItens, [], [], [], []);

  componenteFiltro('vendedor', false, false)
  componenteFiltro('cliente', false, false, 'Cliente', ["TIPO_ENTIDADE = 'C'"])
  componenteFiltro('servico', false, false, 'Opcional');
  componenteFiltro('cliente', false, false, 'Costureira', ["TIPO_ENTIDADE = 'T'"])
  componenteFiltro('cliente', false, false, 'Instalador', ["TIPO_ENTIDADE = 'F'"])
  componenteFiltro('moeda', false, false);
  // componenteFiltro('situacao', false, false);
  // componenteFiltro('historico', false, false);
  // componenteFiltro('classe', false, false);
  // componenteFiltro('funcionario', false, false, 'Instalador')
  // componenteFiltro('funcionario', false, false, 'Costureira')

  function rotinaSaidaCodigo() {
    $("#txtCodigo").on("blur", async function () {
      $("#txtCorTrilho").autocompleta(
        1,
        `JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
          "#txtCodigo"
        )}')"]}`,
        [],
        [],
        [],
      );

      $("#btnCorTrilho").pesquisa_array(
        ["#txtCorTrilho"],
        ["CHAVE"],
        ["DESCRICAO"],
        `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
          "#txtCodigo"
        )}')"]}`,
        "Pesquisa Cor",
        "cadcor",
      )

      $('#btnLimpaCor').on('click', function () {
        $('#txtCorTrilho').val('')
      })
    });
  }

  $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["PRODUTO.CODIGO CHAVE", "PRODUTO.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_PA", "condicao": "GRUPO_PA.CODIGO = PRODUTO.GRUPO"}], "where": ["GRUPO_PA.DESCRICAO LIKE '[PERCENTUAL]CORTINA[PERCENTUAL]'"]}`, [], [], [],
    () => {
      rotinaSaidaCodigo()
    }
  );
  $('#btnCodigo').pesquisa_array(['#txtCodigo'], ['CHAVE'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "PRODUTO.CODIGO CHAVE", "PRODUTO.DESCRICAO DESCRICAO" ], "leftJoin": [{"tabela":"GRUPO_PA", "condicao": "GRUPO_PA.CODIGO = PRODUTO.GRUPO"}], "where": ["GRUPO_PA.DESCRICAO LIKE '[PERCENTUAL]CORTINA[PERCENTUAL]'"]}`, 'Pesquisa Código', 'CODIGO',
    () => {
      rotinaSaidaCodigo()
    });
  $('#btnLimpaCodigo').on('click', function () {
    $('#txtCodigo').val('')
  })

  $("#txtTrilhoFrontal").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]
  $('#btnTrilhoFrontal').pesquisa_serverside(
    ['#txtTrilhoFrontal'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]
    'Pesquisa de Trilho Frontal'
  );
  $('#btnLimpaTrilhoFrontal').on('click', function () {
    $('#txtTrilhoFrontal').val('')
  })

  $("#txtTrilhoTraseiro").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]
  $('#btnTrilhoTraseiro').pesquisa_serverside(
    ['#txtTrilhoTraseiro'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]
    'Pesquisa de Trilho Traseiro'
  );
  $('#btnLimpaTrilhoTraseiro').on('click', function () {
    $('#txtTrilhoTraseiro').val('')
  })

  $("#txtDeslizFrontal").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]
  $('#btnDeslizFrontal').pesquisa_serverside(
    ['#txtDeslizFrontal'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]
    'Pesquisa de Desliz'
  );
  $('#btnLimpaDeslizFrontal').on('click', function () {
    $('#txtDeslizFrontal').val('')
  })

  $("#txtDeslizTraseiro").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]
  $('#btnDeslizTraseiro').pesquisa_serverside(
    ['#txtDeslizTraseiro'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]
    'Pesquisa de Desliz Traseiro'
  );
  $('#btnLimpaDeslizTraseiro').on('click', function () {
    $('#txtDeslizTraseiro').val('')
  })

  $("#txtSuporte").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]
  $('#btnSuporte').pesquisa_serverside(
    ['#txtSuporte'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]
    'Pesquisa de Suporte'
  );
  $('#btnLimpaSuporte').on('click', function () {
    $('#txtSuporte').val('')
  })

  $("#txtSuporteFlange").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]
  $('#btnSuporteFlange').pesquisa_serverside(
    ['#txtSuporteFlange'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]
    'Pesquisa de Suporte Flange'
  );
  $('#btnLimpaSuporteFlange').on('click', function () {
    $('#txtSuporteFlange').val('')
  })

  $("#txtFinalFrontal").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]
  $('#btnFinalFrontal').pesquisa_serverside(
    ['#txtFinalFrontal'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]
    'Pesquisa de Final Frontal'
  );
  $('#btnLimpaFinalFrontal').on('click', function () {
    $('#txtFinalFrontal').val('')
  })

  $("#txtFinalTraseiro").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]
  $('#btnFinalTraseiro').pesquisa_serverside(
    ['#txtFinalTraseiro'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]
    'Pesquisa de Final Traseiro'
  );
  $('#btnLimpaFinalTraseiro').on('click', function () {
    $('#txtFinalTraseiro').val('')
  })

  $("#txtTecido").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["RUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TECIDO[PERCENTUAL]'"]}`);//, "where": ["RUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TECIDO[PERCENTUAL]'"]
  $('#btnTecido').pesquisa_serverside(
    ['#txtTecido'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TECIDO[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TECIDO[PERCENTUAL]'"]
    'Pesquisa de Tecido'
  );
  $('#btnLimpaTecido').on('click', function () {
    $('#txtTecido').val('')
    $('.campoBarraTecido').attr('disabled', true)
    $('.campoDuplaTecido').attr('disabled', true)
    $('.campoFranzTecido').attr('disabled', true)
    // $('.campoInverterTecido').attr('disabled', true)

    $('#selectBarraTecido').val('')
    $('#selectDuplaTecido').val('')
    $('#selectFranzTecido').val('')
    $('#selectInverterTecido').val('')
  })

  $("#txtForro").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FORRO[PERCENTUAL]'"]}`); //, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FORRO[PERCENTUAL]'"]
  $('#btnForro').pesquisa_serverside(
    ['#txtForro'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FORRO[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FORRO[PERCENTUAL]'"]
    'Pesquisa de Forro'
  );

  $('#btnLimpaForro').on('click', function () {
    $('#txtForro').val('')
    $('.campoBarraForro').attr('disabled', true)
    $('.campoDuplaForro').attr('disabled', true)
    $('.campoFranzForro').attr('disabled', true)
    // $('.campoInverterForro').attr('disabled', true)

    $('#selectBarraForro').val('')
    $('#selectDuplaForro').val('')
    $('#selectFranzForro').val('')
    $('#selectInverterForro').val('')
  })

  $("#txtBlackout").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]BLACKOUT[PERCENTUAL]'"]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]BLACKOUT[PERCENTUAL]'"]
  $('#btnBlackout').pesquisa_serverside(
    ['#txtBlackout'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]BLACKOUT[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]BLACKOUT[PERCENTUAL]'"]
    'Pesquisa de Blackout'
  );

  $('#btnLimpaBlackout').on('click', function () {
    $('#txtBlackout').val('')
    $('.campoBarraBlackout').attr('disabled', true)
    $('.campoDuplaBlackout').attr('disabled', true)
    $('.campoFranzBlackout').attr('disabled', true)
    // $('.campoInverterBlackout').attr('disabled', true)

    $('#selectBarraBlackout').val('')
    $('#selectDuplaBlackout').val('')
    $('#selectFranzBlackout').val('')
    $('#selectInverterBlackout').val('')
  })

  function retornaBotaoOpcoes(data, row) {
    var retorno = '<div style="text-align:start;" class="mx-1"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu" style="max-height: 250px; overflow: scroll;scrollbar-gutter: stable; overflow-inline: auto;"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>     ' +
      '</div>';
    return retorno;
  };

  function retornaBotaoOpcoesResultado(data, row) {
    var retorno = '<div style="text-align:start;" class="mx-1"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu" style="max-height: 250px; overflow: scroll;scrollbar-gutter: stable; overflow-inline: auto;"> ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>     ' +
      '</div>';
    return retorno;
  };

  $("#tabelaItens").on("click", "#btnEditar", async function () {
    $('#modalItem').modal('show')
    setTimeout(() => {
      const item = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
      const subItens = $('#tabelaSubItens').DataTable().data()
      $('#txtCodigo').val(item.codigo);
      $('#txtCorTrilho').val(item.cor);
      $('#txtLargura').val(item.largura);
      $('#txtAltura').val(item.altura);
      $('#selectAbertura').val(item.aberturaEm)
      $('#selectKitTrilho').val(item.kitTrilho)
      $('#selectTipoCostura').val(item.tipoCostura)
      $('#selectTipoTrilho').val(item.tipoTrilho)

      subItens.map((subItem) => {
        switch (subItem.tipoLT) {
          case 'TECIDO':
            $('#txtTecido').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            $('#selectBarraTecido').val(subItem.barra * 100)
            $('#selectDuplaTecido').val(subItem.dupla)
            $('#selectFranzTecido').val(subItem.franzido)
            break;
          case 'FORRO':
            $('#txtForro').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            $('#selectBarraForro').val(subItem.barra * 100)
            $('#selectDuplaForro').val(subItem.dupla)
            $('#selectFranzForro').val(subItem.franzido)
            break;

          case 'BLACKOUT':
            $('#txtBlackout').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            $('#selectBarraBlackout').val(subItem.barra * 100)
            $('#selectDuplaBlackout').val(subItem.dupla)
            $('#selectFranzBlackout').val(subItem.franzido)
            break;

          case 'TRILHO_FRONTAL':
            $('#txtTrilhoFrontal').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'TRILHO_TRASEIRO':
            $('#txtTrilhoTraseiro').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'DESLIZ_FRONTAL':
            $('#txtDeslizFrontal').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'DESLIZ_TRASEIRO':
            $('#txtDeslizTraseiro').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'SUPORTE':
            $('#txtSuporte').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'SUPORTE_FLANGE':
            $('#txtSuporteFlange').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'FINAL_FRONTAL':
            $('#txtFinalFrontal').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'FINAL_TRASEIRO':
            $('#txtFinalTraseiro').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          default:
            break;
        }
      }, 100)
    })
  });

  $("#tabelaItens").on("click", "#btnExcluir", function () {
    let table = $("#tabelaItens").DataTable();

    table.row($(this).parents("tr")).remove().draw(false);

    table.rows().every(function (index) {
      let data = this.data();
      data.id = index + 1;
      this.data(data);
    });

    table.draw(false);
  });

  $("#tabelaResultado").on("click", "#btnExcluir", function () {
    let table = $("#tabelaResultado").DataTable();

    table.row($(this).parents("tr")).remove().draw(false);

    table.rows().every(function (index) {
      let data = this.data();
      data.id = index + 1;
      this.data(data);
    });

    table.draw(false);
  });


  await validaEdicao();

  // function BuscaItens() {
  //   const tabelaItens = $('#tabelaItens').DataTable().data()
  //   const retorno = tabelaItens.map((item) => {
  //     return {
  //       id: item.id,
  //       idOrcaDecor: 1,
  //       codigo: item.codigo.split('-')[0].trim(),
  //       cor: item.cor.split('-')[0].trim(),
  //       tipoTrilho: item.tipoTrilho,
  //       kitTrilho: item.kitTrilho,
  //       aberturaEm: item.aberturaEm,
  //       tipoCostura: item.tipoCostura,
  //       quantidade: item.quantidade,
  //       largura: item.largura,
  //       altura: item.altura,
  //       un: item.un,
  //       valor: item.valor,
  //       subTotal: 0,
  //       descUnit: 0,
  //       subDesc: 0,
  //       valorTotal: item.valorTotal,
  //       empId: getCookie('emp_id'),
  //       SubItens: BuscaSubItens(item.id).toArray()
  //     }
  //   })
  //   return retorno
  // }

  // function BuscaSubItens(idItem) {
  //   const tabelaSubItens = $('#tabelaSubItens').DataTable().data()
  //   const retorno = tabelaSubItens.map((subItem) => {
  //     return {
  //       id: subItem.id,
  //       idOrcaItens: idItem,
  //       codigo: subItem.codigo.split('-')[0].trim(),
  //       barra: subItem.barra,
  //       dupla: subItem.dupla,
  //       franzido: subItem.barra,
  //       inverter: subItem.inverter,
  //       tipoLT: subItem.tipoLT,
  //       tm: subItem.tm,
  //       quantidade: subItem.quantidade,
  //       un: subItem.un,
  //       valor: subItem.valor,
  //       valorTotal: subItem.valorTotal,
  //       empId: getCookie('emp_id'),
  //     }
  //   })

  //   return retorno
  // }

  // $("#msform").validate({
  //   debug: false,
  //   ignore: "",
  // rules: {
  //   txtCliente: {
  //     required: true,
  //   },
  //   txtVendedor: { 
  //     required: true,
  //   },
  //   dtEntrega: {
  //     required: true,
  //   },
  // },
  // messages: {
  //   txtCliente: {
  //     required: "Informe um cliente",
  //   },
  //   txtVendedor: {
  //     required: "Informe um vendedor.",
  //   },
  //   dtEntrega: {
  //     required: "Informe uma data de entrega.",
  //   },
  // },
  // errorElement: "span",
  // errorPlacement(error, element) {
  //   error.addClass("invalid-feedback");
  //   element.closest(".form-group").append(error);
  // },
  // highlight(element) {
  //   $(element).addClass("is-invalid");
  // },
  // unhighlight(element) {
  //   $(element).removeClass("is-invalid");
  // },
  // invalidHandler(e, validator) {
  //   if (validator.errorList.length) {
  //     console.log(`erro no: ${$(`#${$(validator.errorList[0].element).prop('id')}`)}`);
  //   }
  // },

  function TrataItens() {
    return itens.map((item) => {
      item.codigo = item.codigo.split('-')[0].trim();
      item.cor = item.cor.split('-')[0].trim();

      item.subItens = item.subItens.map((subItem) => {
        subItem.codigo = subItem.codigo.split('-')[0].trim();
        return subItem; // garante que cada subItem seja retornado
      });

      return item; // garante que cada item seja retornado
    });
  }

  function retornaCondPagto() {
    let arrCondicoes = [];
    let i = 1;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      arrCondicoes.push({
        DIAS: item[0],
        DT_VENCTO: $('#txtDataRec-' + i).val(),
        MOEDA: item[2],
        CODCOND: item[3],
        VALOR: item[5],
        TIPO: 'P',
        NUMERO: pegaValor('#txtNumero'),
        ORDEM: i++
      })
    });
    return arrCondicoes;
  };

  $('#gravar').on('click', async function (event) {
    event.preventDefault();

    if (!$('#txtVendedor').val()) {
      throw new Error('Necessário informar um vendedor para gravar. Por favor, verifique!')
    }
    if (!$('#txtCliente').val()) {
      throw new Error('Necessário informar um cliente para gravar. Por favor, verifique!')
    }
    if (!$('#dtEntrega').val()) {
      throw new Error('Necessário informar uma data de entrega para gravar. Por favor, verifique!')
    }

    let totalCondPagto = 0;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      totalCondPagto += item[5];
    });

    let frete = somarFreteCondicoes ? pegaValor('#txtFrete') ? parseFloat(pegaValor('#txtFrete')) : 0 : 0;
    frete += somarFreteCondicoes ? pegaValor('#txtFreteTrans') ? parseFloat(pegaValor('#txtFreteTrans')) : 0 : 0;
    const despesas = pegaValor('#txtDespesas') ? parseFloat(pegaValor('#txtDespesas')) : 0;

    if ((totalCondPagto != 0) && (TruncaDecimaisNova(2, totalCondPagto) != TruncaDecimaisNova(2, (parseFloat(pegaValor('#txtValorLiq'))) + parseFloat(frete) + parseFloat(despesas)))) {
      msgAlerta('Valor das duplicatas geradas não condiz com o total do pedido.');
      return false;
    }
    $.LoadingOverlay("show");
    try {
      const body = {
        id: parseFloat($('#txtNumero').val()),
        codrep: pegaChave('#txtVendedor'),
        codcli: pegaChave('#txtCliente'),
        codStatus: pegaChave('#txtStatus'),
        dataEntrega: $('#dtEntrega').val(),
        dataCadastro: $('#dtDigitação').val(),
        dataAlteracao: $('#dtEntrega').val(),
        moeda: pegaChave('#txtMoeda'),
        percDesconto: 0,
        obs: '',
        valorBruto: 0,
        valorLiquido: 0,
        empId: getCookie('emp_id'),
        Itens: TrataItens(),
        COND_PAGTO: pegaChave('#txtCondicao'),
        COND_PAGTOS: retornaCondPagto(),
      }
      const response = await requisicao('POST', '/sisplan/orcamento_cortina/v1/salvar?', `&ID=${$('#txtNumero').val()}`, JSON.stringify(body), 90000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        throw new Error(jsonStr.mensagem);
      }

      criaMensagemSucesso('Orçamento gravado com sucesso.', () => { window.location.href = `${BASE_URI}/orcamento_cortina`; });

    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível gravar os dados da ordem de serviço: ${error.message}`);
    } finally {
      $(this).attr('disabled', false);
      $.LoadingOverlay('hide')
    }
    // },
  });

  $('#btnOrcamento').on('click', function () {
    $('#modalItem').modal('show');
  });

  $('#txtCodigo').on('blur', async function () {

    $.LoadingOverlay('show')
    try {
      const codigo = pegaChave('#txtCodigo');
      if (codigo == '') {
        return;
      }

      $('#txtCorTrilho').unbind('autocompleta');
      $('#txtCorTrilho').autocompleta(1, `JSON={ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'"] }`);
      $('#btnCorTrilho').off();
      $('#btnCorTrilho').unbind();
      $('#btnCorTrilho').pesquisa_array(['#txtCorTrilho'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'"]}`, 'Pesquisa Cor', 'CADCOR');

      if (itensAlteracao.length <= 0) {
        $('#txtCorTrilho').val('')

        const pesquisaCor = {
          tabela: "PA_ITEN",
          camposSelect: [
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO"
          ],
          leftJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }],
          groupBy: [
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO"
          ],
          where: [`PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'`],
        }
        const jsonStrCor = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCor));

        if (jsonStrCor && jsonStrCor.length == 1) {
          insereValor('#txtCorTrilho', jsonStrCor[0].COR, jsonStrCor[0].DESCRICAO)
          $('#txtCorTrilho').trigger('blur')
        }
      }
      aplicaInteracoesCampos()
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }

  });

  $('#btnConfirmarOrcamento').on('click', function () {
    objItens.id = $('#tabelaItens').DataTable().data().count() + 1
    objItens.codigo = `${pegaChave('#txtCodigo')} - ${pegaDescricao('#txtCodigo')}`;
    objItens.cor = `${pegaChave('#txtCorTrilho')} - ${pegaDescricao('#txtCorTrilho')}`;
    objItens.quantidade = $('#txtQuantidade').val();
    objItens.largura = $('#txtLargura').val();
    objItens.altura = $('#txtAltura').val();
    objItens.aberturaEm = $('#selectAbertura').val()
    objItens.idOrcaDecor = pegaChave('#txtNumero')
    objItens.kitTrilho = $('#selectKitTrilho').val()
    objItens.quantidade = 1
    objItens.tipoCostura = $('#selectTipoCostura').val()
    objItens.tipoTrilho = $('#selectTipoTrilho').val()
    objItens.un = "M2"
    objItens.empId = getCookie('emp_id')
    objItens.subTotal = 850   //criar função para buscar todos esses valores
    objItens.valorTotal = 780.3   //criar função para buscar todos esses valores
    objItens.valorUnit = 850   //criar função para buscar todos esses valores

    let objSubItens = $('#tabelaResultado').DataTable().data().toArray();
    objItens.subItens = objSubItens;

    itens.push({ ...objItens });

    carregarItensNoGrid(itens);
    preencheTotais()
    $('#modalResultado').modal('hide')
    $('#modalItem').modal('hide')
  });

  async function validaEdicao() {
    if (orcamento != 'create') {
      capaAtual = await buscarOrcamento(orcamento);

      preencherCamposCapa(capaAtual);
      buscaHistoricoOrcamento()
      itens = capaAtual.itens || [];
      carregarItensNoGrid(itens);
    } else {
      $('#txtNumero').val(parseFloat(await RetornaProximo('ORCADECOR', 'ORCADECOR', 'ID', 6)))
      setarDataAtual('dtEntrega');
    }
  }

  function preencherCamposCapa(capa) {
    $('#txtNumero').val(orcamento);
    $('#txtEmpresa').val(capa.empId);
    setTimeout(() => {
      insereValor('#txtVendedor', capa.codrep, { tabela: 'REPRESEN', campoBusca: 'NOME', campoWhere: 'CODREP', valorWhere: capa.codrep })
      insereValor('#txtCliente', capa.codcli, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: capa.codcli })
    }, 200)
    $('#dtEntrega').val(capa.dataEntrega.slice('0', '10'));
    $('#dtDigitacao').val(capa.dataCadastro.slice('0', '10'));
    $('#txtObservacao').val(capa.obs);
  }

  function carregarItensNoGrid(itens) {
    tabelaItens = $('#tabelaItens').DataTable();
    tabelaItens.clear();

    const arrItens = Array.isArray(itens) ? itens : [itens];

    arrItens.forEach((item) => {
      tabelaItens.row.add(item);
    });
    tabelaItens.draw();

    if (arrItens.length > 0) {
      selecionarItemNoGrid(0);
    }
  }

  function selecionarItemNoGrid(index) {
    tabelaItens.$('tr.selected').removeClass('selected');

    const row = tabelaItens.row(index).node();
    $(row).addClass('selected');

    const itemSelecionado = itens[index];
    carregarSubItensNoGrid(itemSelecionado.subItens || []);
  }

  function carregarSubItensNoGrid(subItens) {
    tabelaSubItens = $('#tabelaSubItens').DataTable();
    tabelaSubItens.clear();

    (subItens || []).forEach((subitem) => {
      tabelaSubItens.row.add(subitem);
    });
    tabelaSubItens.draw();
  }

  $(document).on('click', '#tabelaItens tbody tr', function () {
    const idx = tabelaItens.row(this).index();
    selecionarItemNoGrid(idx);
  });

  async function adicionaEmpresas() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    jsonStr.map(emp => {
      $("#selectEmpresa").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, emp.EMP_PAT == getCookie('empresa')));
    });
  };

  function adicionaDias() {
    $('#txtDiasValidade').on('blur', function () {
      const dias = pegaValor('#txtDiasValidade');

      if (dias == '') {
        return;
      }

      setarDataAtual('dtValidade', false, parseFloat(dias));
    });

    $('#txtDias').on('blur', function () {
      const dias = pegaValor('#txtDias');

      if (dias == '') {
        return;
      }

      if ($('#rdSumDiasCorridos').is(':checked')) {
        consideraDiasCorridos(dias)
      }

      if ($('#rdSumDiasUteis').is(':checked')) {
        consideraDiasUteis(dias)
      }
    });
  }

  async function retornaPrecoMat(id, codApl, opcional, codigo, cor) {
    $.LoadingOverlay('show')
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaprecomat?', `ID=${id}&COD_APL=${codApl}&OPCIONAL=${opcional}&CODIGO=${codigo}&COR=${cor}`);

      if (!response) {
        return;
      }

      const jsonPrecoMat = await response.json();

      if (response.status != 200) {
        throw new Error(jsonPrecoMat.mensagem);
      }

      if (jsonPrecoMat.length > 0) {
        let valor = (jsonPrecoMat[0].QTDE_TECIDO * jsonPrecoMat[0].PRECO)
        return valor.toFixed(2)
      } else {
        return 0;
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  function aplicaMascara() {
    $(".camposMascara").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 3,
    });

    $(".camposMascara").on('blur', function () {
      if (($(this).val() == '0.000') || ($(this).val() == '')) {
        $(this).val('0.000');
      }
    });

    $('.camposMascaraQtde').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    })

    $(".camposMascaraQtde").on('blur', function () {
      if (($(this).val() == '0') || ($(this).val() == '')) {
        $(this).val('0');
      }
    });

    $("#txtDias").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
    $("#txtDiasValidade").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
  }

  function criaMascaraCampos() {
    $('.maskDecimais').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $('.maskDecimais').on('blur', function () {
      if ($(this).val() == "") {
        $(this).val('0.00');
      }
    });

    $('.maskInteiro').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });

    $('.maskInteiro').on('blur', function () {
      if ($(this).val() == "") {
        $(this).val('0');
      }
    });

    $('.blurEnter').on('keydown', function () {
      if (event.key == "Enter") {
        $(this).trigger("blur");
      }
    })
  };

  async function addBotoesAvancarVoltar() {
    $(".next").click(async function () {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();
      let validator = $("#msform").validate();
      let liberado = true;
      $('#txtValorLiq').val($('#txtTotal').val())
      $('#txtValorCondicao').val($('#txtTotal').val())
      // if ($(this).attr("id") == "avancar1") {
      //   validator.element("#txtCliente");
      //   validator.element("#txtVendedor");
      //   validator.element("#txtStatus");
      // }

      // if (!(validator.element("#txtCliente") && validator.element("#txtVendedor") && validator.element("#txtStatus"))) {
      //   liberado = false;
      // }

      if (liberado) {
        // if (currentFs.prevObject[0].id == 'avancar1') {
        //   if (!$('#txtCliente').val()) {
        //     throw msgAlerta('Necessário inserir um cliente, verifique!')
        //   }
        // }

        // if (currentFs.prevObject[0].id == 'avancarFinanceiro') {
        //   if (!$('#txtMoeda').val()) {
        //     throw msgAlerta('Necessário inserir uma moeda, verifique!')
        //   }
        //   if (!$('#txtHistorico').val()) {
        //     throw msgAlerta('Necessário inserir um histórico, verifique!')
        //   }
        //   if (!$('#txtSituacao').val()) {
        //     throw msgAlerta('Necessário inserir uma situação, verifique!')
        //   }
        //   if (!$('#txtClasseGer').val()) {
        //     throw msgAlerta('Necessário inserir uma classe, verifique!')
        //   }
        //   if (!$('#txtCondicao').val()) {
        //     throw msgAlerta('Necessário infromar a condição de pagamento, verifique!')
        //   }
        // }

        $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");
        nextFs.show();
        currentFs.animate(
          {
            opacity: 0,
          },
          {
            step(now) {
              opacity = 1 - now;
              currentFs.css({
                display: "none",
                position: "relative",
              });
              nextFs.css({
                opacity,
              });
            },
            duration: 600,
          }
        );
        $("#tabelaItens").DataTable().columns.adjust().draw(false);
        $("#tabelaSubItens").DataTable().columns.adjust().draw(false);
        $("#tabelaCondicao").DataTable().columns.adjust().draw(false);
      }
    });

    $(".previous").click(async function () {
      let currentFs = $(this).parent();
      let previousFs = $(this).parent().prev();
      $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
      previousFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({ display: "none", position: "relative" });
            previousFs.css({ opacity });
          },
          duration: 600,
        }
      );
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
      $("#tabelaSubItens").DataTable().columns.adjust().draw(false);
      $("#tabelaCondicao").DataTable().columns.adjust().draw(false);
    });
  };

  $('#btnDesistir').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      limpaValoresItens()
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function buscarOrcamento(orcamento) {
    $.LoadingOverlay('show')
    try {
      const response = await requisicao('GET', '/sisplan/orcamento_cortina/v1/orcamento_cortina?', `ID=${orcamento}&`);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

      const jsonStr = await response.json();

      return jsonStr

    } catch (error) {
      console.error(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function aplicaInteracoesCampos() {
    $('#modalItem').on('show.bs.modal', function () {
      $('.campoCorTrilho').attr('disabled', false)
      $('.campoTipoCostura').attr('disabled', false)
      $('.campoCostureira').attr('disabled', false)
      $('.campoInstalador').attr('disabled', false)
      $('.campoOpcional').attr('disabled', false)
      $('.campoQuantidade').attr('disabled', false)
      $('.campoObsCostureira').attr('disabled', false)
    })

    $('#txtCorTrilho').on('blur', function () {
      if ($(this).val()) {
        $('.campoLargura').attr('disabled', false)
        $('.campoAltura').attr('disabled', false)
        $('.campoTipoTrilho').attr('disabled', false)
        $('.campoKitTrilho').attr('disabled', false)
        $('.campoAbertura').attr('disabled', false)
      }
    })

    $('#selectTipoTrilho').on('change', function () {
      if ($(this).val() == '0') {
        $('.campoTrilhoFrontal').attr('disabled', false)
        $('.campoTecido').attr('disabled', false)
        $('.campoInverterTecido').attr('disabled', true)
        $('.campoForro').attr('disabled', true)
        $('.campoInverterForro').attr('disabled', true)
        $('.campoBlackout').attr('disabled', true)
        $('.campoInverterBlackout').attr('disabled', true)
      } else {
        $('.campoTrilhoFrontal').attr('disabled', false)
        $('.campoTecido').attr('disabled', false)
        $('.campoInverterTecido').attr('disabled', true)
        $('.campoForro').attr('disabled', false)
        $('.campoInverterForro').attr('disabled', true)
        $('.campoBlackout').attr('disabled', false)
        $('.campoInverterBlackout').attr('disabled', true)
      }
    })

    $('#selectKitTrilho').on('change', function () {
      if ($(this).val() == '1') {
        $('.campoTrilhoTraseiro').attr('disabled', false)
        $('.campoDeslizFrontal').attr('disabled', false)
        $('.campoDeslizTraseiro').attr('disabled', false)
        $('.campoSuporte').attr('disabled', false)
        $('.campoSuporteFlange').attr('disabled', false)
        $('.campoFinalFrontal').attr('disabled', false)
        $('.campoFinalTraseiro').attr('disabled', false)
      } else if ($('#selectTipoTrilho').val() != '0' && $('#selectTipoTrilho').val() != '') {
        $('.campoTrilhoTraseiro').attr('disabled', true)
        $('.campoDeslizFrontal').attr('disabled', false)
        $('.campoDeslizTraseiro').attr('disabled', true)
        $('.campoSuporte').attr('disabled', false)
        $('.campoSuporteFlange').attr('disabled', true)
        $('.campoFinalFrontal').attr('disabled', false)
        $('.campoFinalTraseiro').attr('disabled', true)
      } else {
        $('.campoTrilhoTraseiro').attr('disabled', true)
        $('.campoDeslizFrontal').attr('disabled', true)
        $('.campoDeslizTraseiro').attr('disabled', true)
        $('.campoSuporte').attr('disabled', true)
        $('.campoSuporteFlange').attr('disabled', true)
        $('.campoFinalFrontal').attr('disabled', true)
        $('.campoFinalTraseiro').attr('disabled', true)
      }
    })

    $('#selectTipoCostura').on('change', function () {
      if ($(this).val() == '0') {
        $('.campoTrilhoTraseiro').attr('disabled', true)
        $('.campoDeslizTraseiro').attr('disabled', true)
        $('.campoFinalTraseiro').attr('disabled', true)
        $('.campoTecido').attr('disabled', false)
        $('.campoInverterTecido').attr('disabled', false)
        $('.campoForro').attr('disabled', false)
        $('.campoInverterForro').attr('disabled', false)
        $('.campoBlackout').attr('disabled', false)
        $('.campoInverterBlackout').attr('disabled', false)
      } else if ($(this).val() == '1') {
        $('.campoTrilhoTraseiro').attr('disabled', false)
        $('.campoDeslizTraseiro').attr('disabled', false)
        $('.campoFinalTraseiro').attr('disabled', false)
        $('.campoTecido').attr('disabled', false)
        $('.campoInverterTecido').attr('disabled', false)
        $('.campoForro').attr('disabled', false)
        $('.campoInverterForro').attr('disabled', false)
        $('.campoBlackout').attr('disabled', false)
        $('.campoInverterBlackout').attr('disabled', false)
      } else {
        $('.campoTrilhoTraseiro').attr('disabled', true)
        $('.campoDeslizTraseiro').attr('disabled', true)
        $('.campoFinalTraseiro').attr('disabled', true)
        $('.campoTecido').attr('disabled', true)
        $('.campoInverterTecido').attr('disabled', true)
        $('.campoForro').attr('disabled', true)
        $('.campoInverterForro').attr('disabled', true)
        $('.campoBlackout').attr('disabled', true)
        $('.campoInverterBlackout').attr('disabled', true)
      }
    })

    $('#txtTecido').on('blur', function () {
      if ($(this).val()) {
        $('.campoBarraTecido').attr('disabled', false)
        $('.campoDuplaTecido').attr('disabled', false)
        $('.campoFranzTecido').attr('disabled', false)
        $('.campoInverterTecido').attr('disabled', false)
      } else {
        $('.campoBarraTecido').attr('disabled', true)
        $('.campoDuplaTecido').attr('disabled', true)
        $('.campoFranzTecido').attr('disabled', true)
        $('.campoInverterTecido').attr('disabled', true)
      }
    })

    $('#txtForro').on('blur', function () {
      if ($(this).val()) {
        $('.campoBarraForro').attr('disabled', false)
        $('.campoDuplaForro').attr('disabled', false)
        $('.campoFranzForro').attr('disabled', false)
        $('.campoInverterForro').attr('disabled', false)
      } else {
        $('.campoBarraForro').attr('disabled', true)
        $('.campoDuplaForro').attr('disabled', true)
        $('.campoFranzForro').attr('disabled', true)
        $('.campoInverterForro').attr('disabled', true)
      }
    })

    $('#txtBlackout').on('blur', function () {
      if ($(this).val()) {
        $('.campoBarraBlackout').attr('disabled', false)
        $('.campoDuplaBlackout').attr('disabled', false)
        $('.campoFranzBlackout').attr('disabled', false)
        $('.campoInverterBlackout').attr('disabled', false)
      } else {
        $('.campoBarraBlackout').attr('disabled', true)
        $('.campoDuplaBlackout').attr('disabled', true)
        $('.campoFranzBlackout').attr('disabled', true)
        $('.campoInverterBlackout').attr('disabled', true)
      }
    })
  }

  aplicaInteracoesCampos()

  function limpaValoresItens() {
    $('#txtCodigo').val('')
    $('#txtCorTrilho').val('')
    $('#txtLargura').val('')
    $('#txtAltura').val('')
    $('#selectTipoTrilho').val('')
    $('#selectKitTrilho').val('')
    $('#selectAbertura').val('')
    $('#selectTipoCobertura').val('')
    $('#txtTrilhoFrontal').val('')
    $('#txtTrilhoTraseiro').val('')
    $('#txtDeslizFrontal').val('')
    $('#txtDeslizTraseiro').val('')
    $('#txtSuporte').val('')
    $('#txtSuporteFlange').val('')
    $('#txtFinalFrontal').val('')
    $('#txtFinalTraseiro').val('')
    $('#txtTecido').val('')
    $('#selectBarraTecido').val('')
    $('#selectDuplaTecido').val('')
    $('#selectFranzTecido').val('')
    $('#selectInverterTecido').val('')
    $('#txtForro').val('')
    $('#selectBarraForro').val('')
    $('#selectDuplaForro').val('')
    $('#selectFranzForro').val('')
    $('#selectInverterForro').val('')
    $('#txtBlackout').val('')
    $('#selectBarraBlackout').val('')
    $('#selectDuplaBlackout').val('')
    $('#selectFranzBlackout').val('')
    $('#selectInverterBlackout').val('')
    $('#txtCostureira').val('')
    $('#txtInstalador').val('')
    $('#btnLimpaOpcional').trigger('click')
    $('#txtQuantidade').val('')
    $('#txtObsCostureira').val('')
  }

  $('#modalItem').on('hidden.bs.modal', function () {
    $('#tabelaItens').DataTable().columns.adjust().draw(false)
    itensAlteracao = []
    limpaValoresItens()
  })

  $('#txtQtde').on('keydown', function (e) {
    if (e.key == ',' || e.key == '.') {
      e.preventDefault();
    }
  });

  $('#txtQtde').on('input', function () {
    this.value = this.value.replace(/[^\d-]/g, '');
    this.value = this.value.replace(/(\d+)[.,](\d+)/, '$1');
  });

  $('#voltarAcesso').on('click', async function () {
    await deletaRegistro('ORCAMENTO_CORTINA', getCookie('usuario'), orcamento);
    window.location.href = `${BASE_URI}/orcamento_cortina`;
  })

  async function informacoesCliente(sChave) {
    const pesquisaParam = {
      tabela: "ENTIDADE",
      camposSelect: [
        "ENTIDADE.CODCLI",
        "ENTIDADE.NOME",
        "ENTIDADE.CNPJ",
        "ENTIDADE.EMAIL",
        "ENTIDADE.DDD_FONE",
        "ENTIDADE.TELEFONE",
        "ENTIDADE.COD_PAIS",
        "ENTIDADE.CEP",
        "CIDADE.NOME CIDADE",
        "CIDADE.COD_UF ESTADO",
        "ENTIDADE.BAIRRO",
        "ENTIDADE.ENDERECO",
        "ENTIDADE.NUMERO",
        "ENTIDADE.COMPLEMENTO",
        "ENTIDADE.OBS",
        "ENTIDADE.INSCRICAO",
        "ENTIDADE.DATA_CAD",
        "ENTIDADE.CLASSIFICA",
        "ENTIDADE.PERFIL",
        "PERFIL.DESCRICAO AS DESC_PERFIL",
        "ENTIDADE.GRUPO",
        "GRUPO_CLI.DESCRICAO AS DESC_GRUPO",
        "ENTIDADE.DESCONTO",
        "ENTIDADE.DT_NASC"
      ],
      leftjoin: [{
        tabela: "CADCEP",
        condicao: "ENTIDADE.CEP = CADCEP.CEP"
      },
      {
        tabela: "CIDADE",
        condicao: "CADCEP.CODMUN = CIDADE.CODIGO"
      },
      {
        tabela: "GRUPO_CLI",
        condicao: "ENTIDADE.GRUPO = GRUPO_CLI.CODIGO"
      },
      {
        tabela: "PERFIL",
        condicao: "ENTIDADE.PERFIL = PERFIL.CODIGO"
      }
      ],
      where: [`ENTIDADE.CODCLI = '${sChave}'`],
      camposWhereServerSide: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "CIDADE.NOME", "CADCEP.ESTCEP"]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    $('#txtCpfInfoCliente').val(jsonStr[0].CNPJ);
    $('#txtEmailInfoCliente').val(jsonStr[0].EMAIL);
    $('#txtDddInfoCliente').val(jsonStr[0].DDD_FONE);
    $('#txtTelefoneInfoCliente').val(jsonStr[0].TELEFONE);
    await concatenaPais(jsonStr[0].COD_PAIS);
    $('#txtCepInfoCliente').val(jsonStr[0].CEP);
    $('#txtMunicipioInfoCliente').val(jsonStr[0].CIDADE);
    $('#txtEstadoInfoCliente').val(jsonStr[0].ESTADO);
    $('#txtBairroInfoCliente').val(jsonStr[0].BAIRRO);
    $('#txtEnderecoInfoCliente').val(jsonStr[0].ENDERECO);
    $('#txtNumeroInfoCliente').val(jsonStr[0].NUMERO);
    $('#txtComplementoInfoCliente').val(jsonStr[0].COMPLEMENTO);
    $('#txtObsInfoCliente').val(jsonStr[0].OBS);
    $('#txtInscricaoInfoCliente').val(jsonStr[0].INSCRICAO);
    const classificacaoEntidadeInfo = jsonStr[0].CLASSIFICA.replace('    ', '');
    if (classificacaoEntidadeInfo != '' && classificacaoEntidadeInfo != 'null' && classificacaoEntidadeInfo != null) {
      $('#txtClassificacaoInfoCliente').val(classificacaoEntidadeInfo);
    }
    if (jsonStr[0].GRUPO != '' && jsonStr[0].GRUPO != null) {
      $('#txtGrupoInfoCliente').val(`[${jsonStr[0].GRUPO}] - ${jsonStr[0].DESC_GRUPO}`);
    };
    if (jsonStr[0].PERFIL != '' && jsonStr[0].PERFIL != null) {
      $('#txtPerfilInfoCliente').val(`[${jsonStr[0].PERFIL}] - ${jsonStr[0].DESC_PERFIL}`);
    };
    $('#txtPercDescontoInfoCliente').val(jsonStr[0].DESCONTO);
  }

  $('#txtCondicao').on('focusout', async function () {
    // geraCondicoes();

    let habilita = pegaChave('#txtCondicao') != '';
    if (habilita) {
      await buscaCondicao(pegaChave('#txtCondicao'));
    };
    $('#txtNrParcelas').prop('disabled', habilita);
    $('#txtNrParcelas').prop('disabled', habilita);
    $('#txtIntervaloDias').prop('disabled', habilita);
    atualizaData();
    // $('#btnAtualizar').trigger('click');
  });

  async function buscaCondicao(sNumero) {
    const dadosSelect = {
      tabela: 'CONDICAO',
      camposSelect: ['CONDICAO.NRPAR', 'CONDICAO.NRDIA'],
      where: [`CONDICAO.CODCOND = '${sNumero}'`]
    };

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados da condição.');
      return;
    };
    insereValor('#txtNrParcelas', retornoSelect[0].NRPAR);
    insereValor('#txtIntervaloDias', retornoSelect[0].NRDIA);
  }

  $('#txtMoeda').on('blur', async function () {
    if (!$(this).val()) {
      return
    }
    $('#txtCondicao').val('');
    $('#txtNrParcelas').val('0');
    $('#txtIntervaloDias').val('0');
    await atualizaData();
    $('#txtCondicao').unbind('autocompleta');
    $('#txtCondicao').autocompleta(1, `JSON={ "tabela":"COND_MOEDA", "camposSelect":["COND_MOEDA.CODCOND CHAVE, CONDICAO.DESCRICAO DESCRICAO"], "innerjoin": [{ "tabela" : "CONDICAO", "condicao" : "COND_MOEDA.CODCOND = CONDICAO.CODCOND" }],"where": [] }`, [], [], []);
    $('#btnCondicao').off();
    $('#btnCondicao').unbind('pesquisa');
    $('#btnCondicao').pesquisa_array(['#txtCondicao'], ['CODCOND'], ['DESCRICAO'],
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"COND_MOEDA", 
                                    "camposSelect":[ "COND_MOEDA.CODCOND", "CONDICAO.DESCRICAO" ],
                                    "innerjoin": [{ "tabela" : "CONDICAO", "condicao" : "COND_MOEDA.CODCOND = CONDICAO.CODCOND" }], 
                                    "where": ["COND_MOEDA.MOEDA = '${pegaChave('#txtMoeda')}'"]}`, 'Pesquisa Condição', 'COND_MOEDA');
    habilitaCondicoes();

    $.LoadingOverlay('show')
    try {
      const dadosSelect = {
        tabela: 'MOEDA',
        camposSelect: ['HISTORICO', 'CODSIT', 'CLASSE'],
        where: [`CODMOE = ${pegaChave('#txtMoeda')}`]
      };
      const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
      if (!retornoSelect) {
        return;
      }
      if (retornoSelect.length == 0) {
        return;
      }

      insereValor('#txtSitDup', retornoSelect[0].CODSIT, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: retornoSelect[0].CODSIT });
      insereValor('#txtHistorico', retornoSelect[0].HISTORICO, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: retornoSelect[0].HISTORICO });
      insereValor('#txtClasseGer', retornoSelect[0].CLASSE, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: retornoSelect[0].CLASSE });
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  async function habilitaCondicoes() {
    let habilita = await contemCondicao();
    $('#txtCondicao').prop('disabled', habilita);
    $('#btnCondicao').prop('disabled', habilita);
    $('#btnLimpaCondicao').prop('disabled', habilita);
    $('#txtNrParcelas').prop('disabled', habilita);
    $('#txtIntervaloDias').prop('disabled', habilita);
    $('#dtPrimeiroVencto').prop('disabled', habilita);
    $('#btnLimpar').prop('disabled', habilita);
    $('#btnAtualizar').prop('disabled', habilita);
    $('#txtValorCondicao').val($('#txtValorLiq').val())

    if (habilita) {
      limparTabelaCondicoes();
    }
  };

  async function atualizaData() {
    if ($('#txtIntervaloDias').val() !== '0' || $('#txtIntervaloDias').val() !== '') {
      let intervaloDias;
      let condicao;
      if ($('#txtCondicao').val() != '') {
        condicao = pegaChave('#txtCondicao');

        intervaloDias = await buscaValor('CONDICAO', 'PRAZOINI', 'CODCOND', condicao);

        if (intervaloDias != undefined) {
          intervaloDias = intervaloDias.PRAZOINI;
        }
      } else {
        intervaloDias = parseInt($('#txtIntervaloDias').val());
      }

      const dataAtual = new Date();
      const dataVencimento = new Date(dataAtual.setDate(dataAtual.getDate() + intervaloDias));
      $('#dtPrimeiroVencto').val(dataVencimento.toISOString().substr(0, 10));
    } else {
      await setarDataAtual('dtPrimeiroVencto')
    };
  }

  async function contemCondicao() {
    const moeda = pegaChave('#txtMoeda');

    if ((moeda == '') || (moeda == 'null')) {
      return true;
    };

    const dadosSelect = {
      tabela: 'CONDICAO',
      camposSelect: ['COND_MOEDA.CODCOND'],
      innerJoin: [{ tabela: 'COND_MOEDA', condicao: 'COND_MOEDA.CODCOND = CONDICAO.CODCOND' }],
      where: [`COND_MOEDA.MOEDA = '${moeda}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return true;
    }
    if (retornoSelect.length == 0) {
      return true;
    }
    return false;
  };

  function limparTabelaCondicoes() {
    if ($('#tabelaCondicao').DataTable().rows().count() > 0) {
      $('#tabelaCondicao').empty();
      criaDataTablePadrao('#tabelaCondicao', false, false, false, false, true, true, '250px', null, null, [], [], [], [5]);
      $("#tabelaCondicao").DataTable().columns.adjust().draw(false);
    };
    // $("#dtPrimeiroVencto").val(ne)
  };

  $('#btnAtualizar').on('click', function () {
    const numeroParcelas = $('#txtNrParcelas').val();
    const intervaloDias = $('#txtIntervaloDias').val();
    const dtPrimeiroVencto = $('#dtPrimeiroVencto').val();

    if (numeroParcelas == '') {
      msgAlerta('O número de parcelas não foi preenchido. Não é possível continuar!')
      return
    }
    if (intervaloDias == '') {
      msgAlerta('Intervalo de dias não foi preenchido. Não é possível continuar!')
      return
    }
    if (dtPrimeiroVencto == '') {
      msgAlerta('O primeiro dia de vencimento da parcela não foi preenchido. Não é possível continuar!')
      return
    }

    geraCondicoes();
  });

  $('#btnLimpar').on('click', function () {
    limparTabelaCondicoes();
    limparCamposDias();
    $('#dtPrimeiroVencto').val(new Date().toISOString().slice(0, 10));
    $('#txtCondicao').val('');
    $('#txtNrParcelas').prop('disabled', false);
    $('#txtIntervaloDias').prop('disabled', false);

    $('#txtMoeda').trigger('blur');
  });

  function limparCamposDias() {
    $("#txtNrParcelas, #txtIntervaloDias").val("")
  };

  function limparTabelaCondicoes() {
    if ($('#tabelaCondicao').DataTable().rows().count() > 0) {
      $('#tabelaCondicao').empty();
      criaDataTablePadrao('#tabelaCondicao', false, false, false, false, true, true, '250px', null, null, [], [], [], [5]);
      $("#tabelaCondicao").DataTable().columns.adjust().draw(false);
    };
    // $("#dtPrimeiroVencto").val(ne)
  };

  async function geraCondicoes() {
    const dtVencto = pegaValor('#dtPrimeiroVencto').split('-');
    let dataCondicoes = (new Date().toISOString().slice(0, 10)).split('-');
    let venctoTabela = new Date(dataCondicoes[0], dataCondicoes[1] - 1, dataCondicoes[2], 23, 59, 59);
    let vencto = new Date(dtVencto[0], dtVencto[1] - 1, dtVencto[2], 23, 59, 59);
    if (vencto < new Date()) {
      msgAlerta('Campo "1º Vencimento" menor que a data atual, impossível continuar!');
      return;
    };
    limparTabelaCondicoes()
    let totalCondPagto = 0;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      totalCondPagto += item[5];
    });

    if (totalCondPagto >= (parseFloat(pegaValor('#txtValorLiq')))) {
      msgAlerta('Pagamento total do pedido já preenchido, para alterar necessário limpar as condições.');
      return;
    }

    let data = new Date();
    let dias;
    let total = 0;
    let valor = 0;
    let novoVencto = new Date(dtVencto[0], dtVencto[1] - 1, dtVencto[2], 23, 59, 59);
    let novoVenctoTabela = new Date();
    data.setDate(novoVencto.getDate());
    data.setDate(novoVenctoTabela.getDate());
    const parcelas = pegaValor('#txtNrParcelas') == 0 ? 1 : pegaValor('#txtNrParcelas');
    const moeda = pegaChave('#txtMoeda');
    const condicao = pegaChave('#txtCondicao');
    const descCondicao = pegaDescricao('#txtCondicao');
    const intervalo = pegaValor('#txtIntervaloDias');
    const valorPed = pegaValor('#txtValorCondicao');
    let prazoini = parseFloat($('#txtIntervaloDias').val());
    if ($('#txtCondicao').val() != '') {
      prazoini = await buscaValor('CONDICAO', 'PRAZOINI', 'CODCOND', condicao);
      if (!!prazoini) {
        prazoini = prazoini.PRAZOINI;
      }
    }
    for (let i = 1; i <= parcelas;) {
      // Nesta primeira parte são calculados os dias dos inputs das condições de pagamento (parte superior)
      dias = diferencaDias(venctoTabela, data);
      dias += prazoini;
      valor = TruncaDecimaisNova(2, valorPed / parcelas);
      total += valor;
      if (i == parcelas) {
        valor = TruncaDecimaisNova(2, valor + (valorPed - total));
      };
      const id = '#txtCondPagto' + i;
      i == 1 && --dias;
      $(id).val(dias);
      // Nesta segunda parte são calculados as datas de vencimento a partir do que estiver informado nos campos intervalo de dias, nr. parcelas e 1º vencimento
      // Estas informações são adicionadas na tabela
      const inputData = `<input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataRec-${i}" name="txtDataRec-${i}" value="${formataData(vencto)}"></input>`
      $('#tabelaCondicao').DataTable().row.add([
        dias,
        inputData,
        moeda,
        condicao,
        descCondicao,
        valor
      ]).draw(false);
      novoVenctoTabela.setDate(venctoTabela.getDate() + parseInt(intervalo));
      venctoTabela = novoVenctoTabela;
      novoVencto.setDate(vencto.getDate() + parseInt(intervalo));
      vencto = novoVencto;
      i++
    }
    atualizaValorCondicao();
    totalCondPagto = 0;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      totalCondPagto += item[5];
    });
    $('#txtValorCondicao').val((parseFloat(pegaValor('#txtValorLiq')) - totalCondPagto).toFixed(2));
  };

  function atualizaValorCondicao() {
    let valParcelas = 0;
    const valCondicao = parseFloat(pegaValor('#txtValorCondicao'));
    let frete = somarFreteCondicoes ? pegaValor('#txtFrete') ? parseFloat(pegaValor('#txtFrete')) : 0 : 0;
    frete += somarFreteCondicoes ? pegaValor('#txtFreteTrans') ? parseFloat(pegaValor('#txtFreteTrans')) : 0 : 0;
    const despesas = pegaValor('#txtDespesas') ? parseFloat(pegaValor('#txtDespesas')) : 0;
    const valTotal = parseFloat(pegaValor('#txtValorLiq')) + parseFloat(frete) + parseFloat(despesas);
    // const valTotal = parseFloat(pegaValor('#txtValorLiq'));

    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      valParcelas += item[5];
    });

    if ((valCondicao + valParcelas) > valTotal) {
      insereValor('#txtValorCondicao', (valTotal - valParcelas).toFixed(2));
    }
  }

  function diferencaDias(data1, data2) {
    const diferenca = Math.abs(data1.getTime() - data2.getTime());
    const result = Math.ceil(diferenca / (1000 * 60 * 60 * 24));
    return result;
  };

  async function concatenaPais(sPais) {
    let retorno = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela":"CADPAIS",
        "camposSelect":["NOME"],
        "where": ["CODIGO = '${sPais}'"]}`,
      null
    );
    let jsonString = await retorno.json();
    if (jsonString.RESULT[0] != 0) {
      insereValor($("#txtPaisInfoCliente"), sPais, jsonString.RESULT[0][0].NOME);
    }
    return
  }

  $('#btn-info-cliente').on('click', async function () {
    const clienteTitulo = $('#txtCliente').val().replace('[', '').replace(']', '').split('-');
    await informacoesCliente(pegaChave("#txtCliente"));
    $('#modal-info-cliente').modal('show');
    $('#txtCodigoTittle').html(`${clienteTitulo[0]}-${clienteTitulo[1]}`);
  });

  aplicaMascara();
  $('#carregaHistoricoStatus').on('click', function () {
    $('#modalHistorico').modal('show')
  })

  $('#modalHistorico').on('show.bs.modal', async function () {
    await buscaHistoricoOrcamento()
  })

  function calcularMetroLinear(dados) {
    const { larguraTec, franzido, barra, isDupla } = dados

    const largura = parseFloat($('#txtLargura').val())
    const altura = parseFloat($('#txtAltura').val())
    const entretela = 0.15; // esse valor é fixo sempre
    let barras = isDupla ? barra * 2 : barra; // Se for dupla, dobra a barra
    let comprimento = altura + barras + entretela;

    if (comprimento <= larguraTec) {
      // Sem inversão: largura x franzido
      return (largura * franzido).toFixed(2);
    } else {
      // Com inversão: calcular número de larguras
      let resultado = (largura * franzido) / larguraTec;
      let inteiro = Math.floor(resultado);
      let decimal = resultado - inteiro;

      // Arredondamento: >0.15 arredonda para cima, <=0.15 para baixo
      let numLarguras = (decimal > 0.15) ? inteiro + 1 : inteiro;

      return (comprimento * numLarguras).toFixed(2);
    }
  }

  class DataManager {
    constructor() {
      this.items = [];
    }

    normalizeItem(item, tipo) {
      if (!item) return null;

      if (Array.isArray(item)) {
        return item.map(subItem => ({
          id: null,
          tipo: tipo || subItem.tipoLT,
          preco: subItem.preco || subItem.valor || 0,
          ...subItem
        }));
      }

      return [{
        id: null,
        tipo: tipo || item.tipoLT,
        nome: item.nome || item.descricao || '',
        preco: item.preco || item.valor || 0,
        ...item
      }];
    }

    adicionaItem(dados, tipo) {
      const normalizedData = this.normalizeItem(dados, tipo);
      if (normalizedData && normalizedData.length > 0) {
        this.items.push(...normalizedData);
      }
    }

    adicionaIds() {
      this.items.forEach((item, index) => {
        item.id = index + 1;
      });
    }

    formatarPreco(preco) {
      return new Intl.NumberFormat('pt-BR', {
        style: 'currency',
        currency: 'BRL'
      }).format(preco);
    }

    getItems() {
      return this.items;
    }
  }

  async function retornaItemGenerico({
    idSeletor,
    tipoLT,
    barraSeletor,
    duplaSeletor,
    franzSeletor,
    inverterSeletor,
    quantidade = 1,
    isOpcional = false
  }) {
    const valorInput = $(idSeletor).val();
    if (!valorInput) return null;

    const barra = parseFloat($(barraSeletor).val() / 100) || 0;
    const isDupla = $(duplaSeletor).val() == 1;
    const franzido = parseFloat($(franzSeletor).val()) || 0;
    const inverter = $(inverterSeletor).val() == 'Sim' ? 'S' : 'N'

    const [larguraTec, un, valor] = await Promise.all([
      buscaValor('MATERIAL', 'LARGURA', 'CODIGO', pegaChave(idSeletor)).then(res => res.LARGURA),
      buscaValor('MATERIAL', 'UNIDADE', 'CODIGO', pegaChave(idSeletor)).then(res => res.UNIDADE),
      buscaValor('TABPRECO', 'PRECO_00', 'CODIGO', `${pegaChave(idSeletor)}' AND REGIAO='00003`).then(res => res.PRECO_00)
    ]);

    const metroLinear = calcularMetroLinear({ larguraTec, franzido, barra, isDupla });
    const valorTotal = TruncaDecimaisNova(2, valor * metroLinear * quantidade);

    return {
      codigo: `${pegaChave(idSeletor)} - ${pegaDescricao(idSeletor)}`,
      tipoLT,
      tm: 'MP',
      dimensao: `${parseFloat(larguraTec).toFixed(2)}M`,
      partes: `${parseFloat(larguraTec).toFixed(2)} X ${parseFloat(metroLinear / larguraTec).toFixed(2)}`,
      quantidade: metroLinear,
      un,
      valor,
      valorTotal,
      barra: barra.toFixed(2),
      dupla: isDupla == 'Sim' ? 1 : 0,
      franzido: franzido.toFixed(2),
      inverter
    };
  }

  async function retornaAdicional(idSeletor, tipoLT) {
    const valorInput = $(idSeletor).val();
    if (!valorInput) return null;

    const quantidade = 1;

    let [un, valor] = await Promise.all([
      buscaValor('MATERIAL', 'UNIDADE', 'CODIGO', pegaChave(idSeletor)).then(res => res.UNIDADE),
      buscaValor('TABPRECO', 'PRECO_00', 'CODIGO', `${pegaChave(idSeletor)}' AND REGIAO='00003`).then(res => res.PRECO_00)
    ]);

    if (!valor) valor = 0

    const valorTotal = valor * quantidade;

    return {
      codigo: `${pegaChave(idSeletor)} - ${pegaDescricao(idSeletor)}`,
      tipoLT,
      tm: 'MP',
      dimensao: 'INDEFINIDO',
      partes: '',
      quantidade,
      un,
      valor,
      valorTotal
    };
  }


  async function retornaComposicaoTrilhoFrontal() {
    const idSeletor = '#txtTrilhoFrontal';
    if (!$(idSeletor).val()) return [];

    const pesquisaParam = {
      tabela: 'CARACT',
      camposSelect: [
        'CARACT_CONS.COD_MAT CODIGO', 'MATERIAL.DESCRICAO', `CARACT_CONS.QTDE QUANTIDADE`, 'CARACT_CONS.CUSTO', 'MATERIAL.UNIDADE',
      ],
      leftJoin: [
        { tabela: 'CARACT_CONS', condicao: 'CARACT.ID = CARACT_CONS.ID_CARACT' },
        { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = CARACT_CONS.COD_MAT' },
        { tabela: 'TABLIN', condicao: 'TABLIN.CODIGO = CARACT.COD_LINHA' },
      ],
      where: [`CARACT.COD_GRUPO = '56' AND CARACT.COD_LINHA = '00001'`],
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    return jsonStr.map((item) => ({
      codigo: `${item.CODIGO} - ${item.DESCRICAO}`,
      tipoLT: 'COMPOSICAO_TRILHO_FRONTAL',
      tm: 'MP',
      dimensao: 'INDEFINIDO',
      partes: '',
      quantidade: item.QUANTIDADE,
      un: item.UNIDADE,
      valor: item.CUSTO,
      valorTotal: TruncaDecimaisNova(2, item.CUSTO * item.QUANTIDADE)
    }));
  }

  async function retornaTaxaConfeccao() {
    const taxasConfeccao = [];

    const fetchTaxa = async (grupo, whereExtra) => {
      const pesquisaParam = {
        tabela: 'REGRA_CONSUMO',
        camposSelect: [
          'REGRA_CALCULO.RESULTADO CODIGO, SERVICO.DESCRICAO, SERVICO.PRECO',
        ],
        leftJoin: [
          { tabela: 'REGRA_TABELA', condicao: 'REGRA_CONSUMO.CODIGO = REGRA_TABELA.REGRA' },
          { tabela: 'REGRA_CALCULO', condicao: 'REGRA_CALCULO.REGRA = REGRA_CONSUMO.CODIGO AND REGRA_TABELA.TABELA = REGRA_CALCULO.TABELA' },
          { tabela: 'SERVICO', condicao: 'SERVICO.CODIGO = REGRA_CALCULO.RESULTADO' },
        ],
        where: [`REGRA_TABELA.PARAMETRO = '(LARGURA_ITEM)' ${whereExtra}`],
        // where: [`REGRA_CONSUMO.GRUPO = '${grupo}' AND REGRA_TABELA.PARAMETRO = '(LARGURA_ITEM)' ${whereExtra}`],
        // where: [`REGRA_TABELA.PARAMETRO = '(LARGURA_ITEM)'`],
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      const largura = parseFloat($('#txtLargura').val());

      return {
        codigo: `${jsonStr[0].CODIGO} - ${jsonStr[0].DESCRICAO}`,
        tipoLT: 'TAXA_CONFECCAO',
        tm: 'SE',
        dimensao: 'INDEFINIDO',
        partes: '',
        quantidade: largura,
        un: 'SE',
        valor: jsonStr[0].PRECO,
        valorTotal: TruncaDecimaisNova(2, jsonStr[0].PRECO * largura)
      };
    };

    if ($('#txtTecido').val()) {
      taxasConfeccao.push(await fetchTaxa('00', `AND ${largura} BETWEEN PARAM_INICIAL AND PARAM_FINAL`));
    }

    if ($('#txtForro').val()) {
      taxasConfeccao.push(await fetchTaxa('30', `AND PARAM_INICIAL >= ${largura}`));
    }

    return taxasConfeccao;
  }

  async function retornaTaxaInstalacao() {
    const idSeletor = '#txtOpcional';
    if (!$(idSeletor).val()) return null;

    const valor = await buscaValor('SERVICO', 'PRECO', 'CODIGO', pegaChave(idSeletor)).then(res => res.PRECO);
    const largura = parseFloat($('#txtQuantidade').val());

    return {
      codigo: `${pegaChave(idSeletor)} - ${pegaDescricao(idSeletor)}`,
      tipoLT: 'OPCIONAL',
      tm: 'SE',
      dimensao: 'INDEFINIDO',
      partes: '',
      quantidade: largura,
      un: 'SE',
      valor,
      valorTotal: TruncaDecimaisNova(2, valor * largura)
    };
  }

  async function retornaOrcamento() {
    try {
      const dataManager = new DataManager();

      const [
        tecidos,
        forro,
        blackout,
        trilhoFrontal,
        trilhoTraseiro,
        deslizFrontal,
        deslizTraseiro,
        suporte,
        suporteFlange,
        finalFrontal,
        finalTraseiro,
        composicaoTrilhoFrontal,
        taxasConfeccao,
        taxaInstalacao
      ] = await Promise.all([
        retornaItemGenerico({
          idSeletor: '#txtTecido',
          tipoLT: 'TECIDO',
          barraSeletor: '#selectBarraTecido',
          duplaSeletor: '#selectDuplaTecido',
          franzSeletor: '#selectFranzTecido',
          inverterSeletor: '#selectInverterTecido'
        }),
        retornaItemGenerico({
          idSeletor: '#txtForro',
          tipoLT: 'FORRO',
          barraSeletor: '#selectBarraForro',
          duplaSeletor: '#selectDuplaForro',
          franzSeletor: '#selectFranzForro',
          inverterSeletor: '#selectInverterTecido'
        }),
        retornaItemGenerico({
          idSeletor: '#txtBlackout',
          tipoLT: 'BLACKOUT',
          barraSeletor: '#selectBarraBlackout',
          duplaSeletor: '#selectDuplaBlackout',
          franzSeletor: '#selectFranzBlackout',
          inverterSeletor: '#selectInverterTecido',
        }),
        retornaAdicional('#txtTrilhoFrontal', 'TRILHO_FRONTAL'),
        retornaAdicional('#txtTrilhoTraseiro', 'TRILHO_TRASEIRO'),
        retornaAdicional('#txtDeslizFrontal', 'DESLIZ_FRONTAL'),
        retornaAdicional('#txtDeslizTraseiro', 'DESLIZ_TRASEIRO'),
        retornaAdicional('#txtSuporte', 'SUPORTE'),
        retornaAdicional('#txtSuporteFlaneg', 'SUPORTE_FLANGE'),
        retornaAdicional('#txtFinalFrontal', 'FINAL_FRONTAL'),
        retornaAdicional('#txtFinalTraseiro', 'FINAL_TRASEIRO'),
        retornaComposicaoTrilhoFrontal(),
        retornaTaxaConfeccao(),
        retornaTaxaInstalacao()
      ]);

      dataManager.adicionaItem(tecidos, 'Tecidos');
      dataManager.adicionaItem(forro, 'Forro');
      dataManager.adicionaItem(blackout, 'Blackout');
      dataManager.adicionaItem(trilhoFrontal, 'TrilhoFrontal');
      dataManager.adicionaItem(trilhoTraseiro, 'TrilhoTraseiro,');
      dataManager.adicionaItem(deslizFrontal, 'DeslizFrontal,');
      dataManager.adicionaItem(deslizTraseiro, 'DeslizTraseiro,');
      dataManager.adicionaItem(suporte, 'Suporte,');
      dataManager.adicionaItem(suporteFlange, 'SuporteFlange,');
      dataManager.adicionaItem(finalFrontal, 'FinalFrontal,');
      dataManager.adicionaItem(finalTraseiro, 'FinalTraseiro,');

      composicaoTrilhoFrontal.forEach(item => {
        dataManager.adicionaItem(item, 'ComposicaoTrilhoFrontal');
      });

      taxasConfeccao.forEach(item => {
        dataManager.adicionaItem(item, 'TaxasConfeccao');
      });

      dataManager.adicionaItem(taxaInstalacao, 'TaxaInstalacao');

      dataManager.adicionaIds();

      return dataManager.getItems();

    } catch (error) {
      console.error('Erro ao retornar orçamento:', error);
      return [];
    }
  }

  function validaCamposCalculo() {
    if (!$('#txtCodigo').val()) {
      throw new Error('Necessário informar uma cortina para continuar. Por favor, verifique!')
    }
    if (!$('#txtCorTrilho').val()) {
      throw new Error('Necessário informar uma cor do trilho. Por favor, verifique!')
    }
    if (!$('#txtLargura').val()) {
      throw new Error('Necessário informar a largura da cortina. Por favor, verifique!')
    }
    if (!$('#txtAltura').val()) {
      throw new Error('Necessário informar a altura da cortina. Por favor, verifique!')
    }
    if (!$('#selectTipoTrilho').val()) {
      throw new Error('Necessário informar um tipo de trilho para continuar. Por favor, verifique!')
    }
    if (!$('#txtTrilhoFrontal').val()) {
      throw new Error('Necessário informar um trilho frontal para continuar. Por favor, verifique!')
    }
    if (!$('#txtTecido').val()) {
      throw new Error('Necessário informar um tecido para continuar. Por favor, verifique!')
    }
  }

  $('#calcular').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      validaCamposCalculo()
      const items = await retornaOrcamento();
      objOrcamento = items
      $('#modalResultado').modal('show');

      if ($.fn.DataTable.isDataTable('#tabelaResultado')) {
        $('#tabelaResultado').DataTable().destroy();
        $('#tabelaResultado').empty();
      }

      $('#tabelaResultado').DataTable({
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        lengthChange: false,
        searching: false,
        paging: false,
        info: false,
        data: items,
        columns: columnsSubItens,
        columnDefs: [
          {
            targets: 0,
            render(data, type, row) {
              return retornaBotaoOpcoesResultado(data, row);
            },
          },
          {
            targets: 0,
            type: "num"
          }
        ]
      });

    } catch (error) {
      msgAlerta(error.message || 'Não foi possível calcular o orçamento, verifique!');
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaTotais() {
    let tabela = ''
    if ($.fn.DataTable.isDataTable('#tabelaResultado')) {
      tabela = $('#tabelaResultado').DataTable().data().toArray()
    } else {
      tabela = $('#tabelaSubItens').DataTable().data().toArray()
    }

    const totais = tabela.reduce(
      (acc, item) => {
        if (item.tm === 'SE') {
          acc.totalMaterial += item.valorTotal;
        } else {
          acc.totalServico += item.valorTotal;
        }
        acc.total += TruncaDecimaisNova(2, item.valorTotal);
        return acc;
      },
      { totalServico: 0, totalMaterial: 0, total: 0 }
    );

    return totais;
  }

  function preencheTotais() {
    retornaTotais().then((result) => {
      $('#txtTotalServico').val(TruncaDecimaisNova(2, result.totalServico))
      $('#txtTotalMaterial').val(TruncaDecimaisNova(2, result.totalMaterial))
      $('#txtTotal').val(TruncaDecimaisNova(2, result.total))
    })
  }

  async function buscaHistoricoOrcamento() {
    if ($.fn.DataTable.isDataTable('#tabelaHistoricoOrcamento')) {
      $('#tabelaHistoricoOrcamento').DataTable().destroy();
      $('#tabelaHistoricoOrcamento').empty();
    };

    const response = await requisicao('GET', '/sisplan/orcamento_cortina/v1/historico?', `ID=${orcamento}&`);

    if (!response) {
      return;
    }

    if (response.status != 200) {
      const jsonStr = await response.json();
      msgAlerta(jsonStr.mensagem);
      return;
    }

    const jsonStr = await response.json();

    $('#txtStatus').val(jsonStr[0].OCORRENCIA)

    try {
      $('#tabelaHistoricoOrcamento').DataTable({
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        lengthChange: false,
        searching: false,
        paging: false,
        info: false,
        data: jsonStr,
        columns: columnsHistorico,
        columnDefs: [
          {
            type: 'date-br',
            targets: [3],
            render: function (data) {
              if (data != undefined && data != '') {
                const x = data.slice(0, 10).split('-');
                const hora = data.split(' ')[1];
                if (x[2]) {
                  return `${x[2]}/${x[1]}/${x[0]}`;
                } else {
                  return `${x} ${hora}`;
                }
              } else {
                return '';
              }
            }
          },
        ]
      });

    } catch (error) {
      msgAlerta(error.message || 'Não foi possível encontrar o histórico do orçamento')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  preencheTotais()

  $(".collapse")
    .on("shown.bs.collapse", function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

      clicked
        .parent()
        .find(".fa-angle-right")
        .removeClass("fa-angle-right")
        .addClass("fa-angle-down");
    })
    .on("hidden.bs.collapse", function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

      clicked
        .parent()
        .find(".fa-angle-down")
        .removeClass("fa-angle-down")
        .addClass("fa-angle-right");
    });
});

